/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.OperationDefinitionHelper;
import org.jboss.as.messaging.SecurityRoleDefinition;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class HornetQServerControlHandler
extends AbstractRuntimeOnlyHandler {
    static final HornetQServerControlHandler INSTANCE = new HornetQServerControlHandler();
    public static final AttributeDefinition ACTIVE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"active", (ModelType)ModelType.BOOLEAN).setStorageRuntime()).build();
    public static final AttributeDefinition STARTED = new SimpleAttributeDefinition("started", ModelType.BOOLEAN, false, new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME});
    public static final AttributeDefinition VERSION = new SimpleAttributeDefinition("version", ModelType.STRING, false, new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME});
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{STARTED, VERSION, ACTIVE};
    public static final String GET_CONNECTORS_AS_JSON = "get-connectors-as-json";
    public static final String RESET_ALL_MESSAGE_COUNTERS = "reset-all-message-counters";
    public static final String RESET_ALL_MESSAGE_COUNTER_HISTORIES = "reset-all-message-counter-histories";
    public static final String LIST_PREPARED_TRANSACTIONS = "list-prepared-transactions";
    public static final String LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON = "list-prepared-transaction-details-as-json";
    public static final String LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML = "list-prepared-transaction-details-as-html";
    public static final String LIST_HEURISTIC_COMMITTED_TRANSACTIONS = "list-heuristic-committed-transactions";
    public static final String LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS = "list-heuristic-rolled-back-transactions";
    public static final String COMMIT_PREPARED_TRANSACTION = "commit-prepared-transaction";
    public static final String ROLLBACK_PREPARED_TRANSACTION = "rollback-prepared-transaction";
    public static final String LIST_REMOTE_ADDRESSES = "list-remote-addresses";
    public static final String CLOSE_CONNECTIONS_FOR_ADDRESS = "close-connections-for-address";
    public static final String LIST_CONNECTION_IDS = "list-connection-ids";
    public static final String LIST_PRODUCERS_INFO_AS_JSON = "list-producers-info-as-json";
    public static final String LIST_SESSIONS = "list-sessions";
    public static final String GET_ROLES = "get-roles";
    @Deprecated
    public static final String GET_ROLES_AS_JSON = "get-roles-as-json";
    public static final String GET_ADDRESS_SETTINGS_AS_JSON = "get-address-settings-as-json";
    public static final String FORCE_FAILOVER = "force-failover";
    public static final String HQ_SERVER = "hornetq-server";
    public static final AttributeDefinition TRANSACTION_AS_BASE_64 = OperationDefinitionHelper.createNonEmptyStringAttribute("transaction-as-base-64");
    public static final AttributeDefinition ADDRESS_MATCH = OperationDefinitionHelper.createNonEmptyStringAttribute("address-match");
    public static final AttributeDefinition CONNECTION_ID = OperationDefinitionHelper.createNonEmptyStringAttribute("connection-id");
    public static final AttributeDefinition REQUIRED_IP_ADDRESS = OperationDefinitionHelper.createNonEmptyStringAttribute("ip-address");
    public static final AttributeDefinition OPTIONAL_IP_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ip-address", (ModelType)ModelType.STRING).setAllowNull(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).build();

    private HornetQServerControlHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block25: {
            String operationName = operation.require("operation").asString();
            ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
            ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
            if (hqService == null || hqService.getState() != ServiceController.State.UP) {
                throw MessagingLogger.ROOT_LOGGER.hornetQServerNotInstalled(hqServiceName.getSimpleName());
            }
            HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            if ("read-attribute".equals(operationName)) {
                this.handleReadAttribute(context, operation, hqServer);
                context.stepCompleted();
                return;
            }
            if (HornetQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            HornetQServerControl serverControl = this.getServerControl(context, operation);
            try {
                if (GET_CONNECTORS_AS_JSON.equals(operationName)) {
                    String json = serverControl.getConnectorsAsJSON();
                    context.getResult().set(json);
                    break block25;
                }
                if (RESET_ALL_MESSAGE_COUNTERS.equals(operationName)) {
                    serverControl.resetAllMessageCounters();
                    context.getResult();
                    break block25;
                }
                if (RESET_ALL_MESSAGE_COUNTER_HISTORIES.equals(operationName)) {
                    serverControl.resetAllMessageCounterHistories();
                    context.getResult();
                    break block25;
                }
                if (LIST_PREPARED_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listPreparedTransactions();
                    ManagementUtil.reportListOfStrings(context, list);
                    break block25;
                }
                if (LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listPreparedTransactionDetailsAsJSON();
                    context.getResult().set(json);
                    break block25;
                }
                if (LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML.equals(operationName)) {
                    String html = serverControl.listPreparedTransactionDetailsAsHTML();
                    context.getResult().set(html);
                    break block25;
                }
                if (LIST_HEURISTIC_COMMITTED_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listHeuristicCommittedTransactions();
                    ManagementUtil.reportListOfStrings(context, list);
                    break block25;
                }
                if (LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listHeuristicRolledBackTransactions();
                    ManagementUtil.reportListOfStrings(context, list);
                    break block25;
                }
                if (COMMIT_PREPARED_TRANSACTION.equals(operationName)) {
                    String txId = TRANSACTION_AS_BASE_64.resolveModelAttribute(context, operation).asString();
                    boolean committed = serverControl.commitPreparedTransaction(txId);
                    context.getResult().set(committed);
                    break block25;
                }
                if (ROLLBACK_PREPARED_TRANSACTION.equals(operationName)) {
                    String txId = TRANSACTION_AS_BASE_64.resolveModelAttribute(context, operation).asString();
                    boolean committed = serverControl.rollbackPreparedTransaction(txId);
                    context.getResult().set(committed);
                    break block25;
                }
                if (LIST_REMOTE_ADDRESSES.equals(operationName)) {
                    ModelNode address = OPTIONAL_IP_ADDRESS.resolveModelAttribute(context, operation);
                    String[] list = address.isDefined() ? serverControl.listRemoteAddresses(address.asString()) : serverControl.listRemoteAddresses();
                    ManagementUtil.reportListOfStrings(context, list);
                    break block25;
                }
                if (CLOSE_CONNECTIONS_FOR_ADDRESS.equals(operationName)) {
                    String address = REQUIRED_IP_ADDRESS.resolveModelAttribute(context, operation).asString();
                    boolean closed = serverControl.closeConnectionsForAddress(address);
                    context.getResult().set(closed);
                    break block25;
                }
                if (LIST_CONNECTION_IDS.equals(operationName)) {
                    String[] list = serverControl.listConnectionIDs();
                    ManagementUtil.reportListOfStrings(context, list);
                    break block25;
                }
                if (LIST_PRODUCERS_INFO_AS_JSON.equals(operationName)) {
                    String json = serverControl.listProducersInfoAsJSON();
                    context.getResult().set(json);
                    break block25;
                }
                if (LIST_SESSIONS.equals(operationName)) {
                    String connectionID = CONNECTION_ID.resolveModelAttribute(context, operation).asString();
                    String[] list = serverControl.listSessions(connectionID);
                    ManagementUtil.reportListOfStrings(context, list);
                    break block25;
                }
                if (GET_ROLES.equals(operationName)) {
                    String addressMatch = ADDRESS_MATCH.resolveModelAttribute(context, operation).asString();
                    String json = serverControl.getRolesAsJSON(addressMatch);
                    ManagementUtil.reportRoles(context, json);
                    break block25;
                }
                if (GET_ROLES_AS_JSON.equals(operationName)) {
                    String addressMatch = ADDRESS_MATCH.resolveModelAttribute(context, operation).asString();
                    String json = serverControl.getRolesAsJSON(addressMatch);
                    ManagementUtil.reportRolesAsJSON(context, json);
                    break block25;
                }
                if (GET_ADDRESS_SETTINGS_AS_JSON.equals(operationName)) {
                    String addressMatch = ADDRESS_MATCH.resolveModelAttribute(context, operation).asString();
                    String json = serverControl.getAddressSettingsAsJSON(addressMatch);
                    context.getResult().set(json);
                    break block25;
                }
                if (FORCE_FAILOVER.equals(operationName)) {
                    serverControl.forceFailover();
                    context.getResult();
                    break block25;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
        context.stepCompleted();
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)this);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_CONNECTORS_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(RESET_ALL_MESSAGE_COUNTERS, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(RESET_ALL_MESSAGE_COUNTER_HISTORIES, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PREPARED_TRANSACTIONS, resolver).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_HEURISTIC_COMMITTED_TRANSACTIONS, resolver).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS, resolver).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(COMMIT_PREPARED_TRANSACTION, resolver).setParameters(new AttributeDefinition[]{TRANSACTION_AS_BASE_64}).setReplyType(ModelType.BOOLEAN).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(ROLLBACK_PREPARED_TRANSACTION, resolver).setParameters(new AttributeDefinition[]{TRANSACTION_AS_BASE_64}).setReplyType(ModelType.BOOLEAN).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_REMOTE_ADDRESSES, resolver).setParameters(new AttributeDefinition[]{OPTIONAL_IP_ADDRESS}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(CLOSE_CONNECTIONS_FOR_ADDRESS, resolver).setParameters(new AttributeDefinition[]{REQUIRED_IP_ADDRESS}).setReplyType(ModelType.BOOLEAN).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_CONNECTION_IDS, resolver).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_PRODUCERS_INFO_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_SESSIONS, resolver).setParameters(new AttributeDefinition[]{CONNECTION_ID}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_ROLES_AS_JSON, resolver).setParameters(new AttributeDefinition[]{ADDRESS_MATCH}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_ADDRESS_SETTINGS_AS_JSON, resolver).setParameters(new AttributeDefinition[]{ADDRESS_MATCH}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(FORCE_FAILOVER, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(GET_ROLES, resolver).setParameters(new AttributeDefinition[]{ADDRESS_MATCH}).setReplyType(ModelType.LIST).setReplyParameters(new AttributeDefinition[]{SecurityRoleDefinition.NAME, SecurityRoleDefinition.SEND, SecurityRoleDefinition.CONSUME, SecurityRoleDefinition.CREATE_DURABLE_QUEUE, SecurityRoleDefinition.DELETE_DURABLE_QUEUE, SecurityRoleDefinition.CREATE_NON_DURABLE_QUEUE, SecurityRoleDefinition.DELETE_NON_DURABLE_QUEUE, SecurityRoleDefinition.MANAGE}).build(), (OperationStepHandler)this);
    }

    private void handleReadAttribute(OperationContext context, ModelNode operation, HornetQServer server) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (STARTED.getName().equals(name)) {
            boolean started = server.isStarted();
            context.getResult().set(started);
        } else if (VERSION.getName().equals(name)) {
            String version = server.getVersion().getFullVersion();
            context.getResult().set(version);
        } else if (ACTIVE.getName().equals(name)) {
            boolean active = server.isActive();
            context.getResult().set(active);
        } else {
            throw MessagingLogger.ROOT_LOGGER.unsupportedAttribute(name);
        }
    }

    private HornetQServerControl getServerControl(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        if (hqService == null || hqService.getState() != ServiceController.State.UP) {
            throw MessagingLogger.ROOT_LOGGER.hornetQServerNotInstalled(hqServiceName.getSimpleName());
        }
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        return hqServer.getHornetQServerControl();
    }
}

