/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.AddressSettingsResolveHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQServerAdd;
import org.jboss.as.messaging.HornetQServerControlHandler;
import org.jboss.as.messaging.HornetQServerControlWriteHandler;
import org.jboss.as.messaging.HornetQServerRemove;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.JMSServerControlHandler;
import org.jboss.dmr.ModelNode;

public class HornetQServerResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement HORNETQ_SERVER_PATH = PathElement.pathElement((String)"hornetq-server");
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{CommonAttributes.ASYNC_CONNECTION_EXECUTION_ENABLED, CommonAttributes.PERSISTENCE_ENABLED, CommonAttributes.SECURITY_ENABLED, CommonAttributes.SECURITY_INVALIDATION_INTERVAL, CommonAttributes.WILD_CARD_ROUTING_ENABLED, CommonAttributes.MANAGEMENT_ADDRESS, CommonAttributes.MANAGEMENT_NOTIFICATION_ADDRESS, CommonAttributes.JMX_MANAGEMENT_ENABLED, CommonAttributes.JMX_DOMAIN, CommonAttributes.STATISTICS_ENABLED, CommonAttributes.MESSAGE_COUNTER_ENABLED, CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD, CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY, CommonAttributes.CONNECTION_TTL_OVERRIDE, CommonAttributes.TRANSACTION_TIMEOUT, CommonAttributes.TRANSACTION_TIMEOUT_SCAN_PERIOD, CommonAttributes.MESSAGE_EXPIRY_SCAN_PERIOD, CommonAttributes.MESSAGE_EXPIRY_THREAD_PRIORITY, CommonAttributes.ID_CACHE_SIZE, CommonAttributes.PERSIST_ID_CACHE, CommonAttributes.BACKUP, CommonAttributes.ALLOW_FAILBACK, CommonAttributes.FAILBACK_DELAY, CommonAttributes.FAILOVER_ON_SHUTDOWN, CommonAttributes.SHARED_STORE, CommonAttributes.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY, CommonAttributes.PAGE_MAX_CONCURRENT_IO, CommonAttributes.CREATE_BINDINGS_DIR, CommonAttributes.CREATE_JOURNAL_DIR, CommonAttributes.JOURNAL_TYPE, CommonAttributes.JOURNAL_BUFFER_TIMEOUT, CommonAttributes.JOURNAL_BUFFER_SIZE, CommonAttributes.JOURNAL_SYNC_TRANSACTIONAL, CommonAttributes.JOURNAL_SYNC_NON_TRANSACTIONAL, CommonAttributes.LOG_JOURNAL_WRITE_RATE, CommonAttributes.JOURNAL_FILE_SIZE, CommonAttributes.JOURNAL_MIN_FILES, CommonAttributes.JOURNAL_COMPACT_PERCENTAGE, CommonAttributes.JOURNAL_COMPACT_MIN_FILES, CommonAttributes.JOURNAL_MAX_IO, CommonAttributes.PERF_BLAST_PAGES, CommonAttributes.RUN_SYNC_SPEED_TEST, CommonAttributes.SERVER_DUMP_INTERVAL};
    private final boolean registerRuntimeOnly;

    HornetQServerResourceDefinition(boolean registerRuntimeOnly) {
        super(HORNETQ_SERVER_PATH, MessagingExtension.getResourceDescriptionResolver("hornetq-server"), (OperationStepHandler)HornetQServerAdd.INSTANCE, (OperationStepHandler)HornetQServerRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.registerRuntimeOnly) {
            HornetQServerControlHandler.INSTANCE.registerOperations(resourceRegistration, this.getResourceDescriptionResolver());
            JMSServerControlHandler.INSTANCE.registerOperations(resourceRegistration, this.getResourceDescriptionResolver());
            AddressSettingsResolveHandler.registerOperationHandler(resourceRegistration, this.getResourceDescriptionResolver());
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        HornetQServerControlWriteHandler.INSTANCE.registerAttributes(resourceRegistration, this.registerRuntimeOnly);
        if (this.registerRuntimeOnly) {
            HornetQServerControlHandler.INSTANCE.registerAttributes(resourceRegistration);
        }
    }

    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
        if (this.registerRuntimeOnly) {
            return super.getDescriptionProvider(resourceRegistration);
        }
        return new DefaultResourceDescriptionProvider(resourceRegistration, this.getResourceDescriptionResolver()){

            public ModelNode getModelDescription(Locale locale) {
                ModelNode result = super.getModelDescription(locale);
                result.get(new String[]{"children", "path", "min-occurs"}).set(4);
                result.get(new String[]{"children", "path", "max-occurs"}).set(4);
                return result;
            }
        };
    }
}

