/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import java.util.Set;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.SecurityRoleDefinition;
import org.jboss.as.messaging.SecurityRoleRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class SecurityRoleAdd
extends AbstractAddStepHandler {
    static final SecurityRoleAdd INSTANCE = new SecurityRoleAdd((AttributeDefinition[])SecurityRoleDefinition.ATTRIBUTES);

    private SecurityRoleAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        if (context.isNormalServer()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            HornetQServer server = SecurityRoleAdd.getServer(context, operation);
            String match = address.getElement(address.size() - 2).getValue();
            String roleName = address.getLastElement().getValue();
            if (server != null) {
                Role role = SecurityRoleDefinition.transform(context, roleName, model);
                Set roles = (Set)server.getSecurityRepository().getMatch(match);
                roles.add(role);
                server.getSecurityRepository().addMatch(match, (Object)roles);
            }
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        HornetQServer server = SecurityRoleAdd.getServer(context, operation);
        String match = address.getElement(address.size() - 2).getValue();
        String roleName = address.getLastElement().getValue();
        SecurityRoleRemove.removeRole(server, match, roleName);
    }

    static HornetQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(hqServiceName);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

