/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.JMSConnectionFactoryDefinition;
import javax.jms.JMSConnectionFactoryDefinitions;
import javax.jms.JMSDestinationDefinition;
import javax.jms.JMSDestinationDefinitions;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.structure.EJBAnnotationPropertyReplacement;
import org.jboss.as.messaging.deployment.DirectJMSConnectionFactoryInjectionSource;
import org.jboss.as.messaging.deployment.DirectJMSDestinationInjectionSource;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;

public class MessagingJMSDefinitionAnnotationParser
implements DeploymentUnitProcessor {
    private static final DotName JMS_DESTINATION_DEFINITION = DotName.createSimple((String)JMSDestinationDefinition.class.getName());
    private static final DotName JMS_DESTINATION_DEFINITIONS = DotName.createSimple((String)JMSDestinationDefinitions.class.getName());
    private static final DotName JMS_CONNECTION_FACTORY_DEFINITION = DotName.createSimple((String)JMSConnectionFactoryDefinition.class.getName());
    private static final DotName JMS_CONNECTION_FACTORY_DEFINITIONS = DotName.createSimple((String)JMSConnectionFactoryDefinitions.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        AnnotationTarget target;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        PropertyReplacer propertyReplacer = EJBAnnotationPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit);
        for (AnnotationInstance annotation : index.getAnnotations(JMS_DESTINATION_DEFINITIONS)) {
            target = annotation.target();
            if (!(target instanceof ClassInfo)) {
                throw EeLogger.ROOT_LOGGER.classOnlyAnnotation(JMS_DESTINATION_DEFINITIONS.toString(), target);
            }
            List<AnnotationInstance> destinationDefinitions = MessagingJMSDefinitionAnnotationParser.getNestedDefinitionAnnotations(annotation);
            for (AnnotationInstance definition : destinationDefinitions) {
                this.processJMSDestinationDefinition(deploymentUnit, eeModuleDescription, definition, (ClassInfo)target, applicationClasses, propertyReplacer);
            }
        }
        for (AnnotationInstance definition : index.getAnnotations(JMS_DESTINATION_DEFINITION)) {
            target = definition.target();
            if (!(target instanceof ClassInfo)) {
                throw EeLogger.ROOT_LOGGER.classOnlyAnnotation(JMS_DESTINATION_DEFINITION.toString(), target);
            }
            this.processJMSDestinationDefinition(deploymentUnit, eeModuleDescription, definition, (ClassInfo)target, applicationClasses, propertyReplacer);
        }
        for (AnnotationInstance annotation : index.getAnnotations(JMS_CONNECTION_FACTORY_DEFINITIONS)) {
            target = annotation.target();
            if (!(target instanceof ClassInfo)) {
                throw EeLogger.ROOT_LOGGER.classOnlyAnnotation(JMS_CONNECTION_FACTORY_DEFINITIONS.toString(), target);
            }
            List<AnnotationInstance> connectionFactoryDefinitions = MessagingJMSDefinitionAnnotationParser.getNestedDefinitionAnnotations(annotation);
            for (AnnotationInstance definition : connectionFactoryDefinitions) {
                this.processJMSConnectionFactoryDefinition(deploymentUnit, eeModuleDescription, definition, (ClassInfo)target, applicationClasses, propertyReplacer);
            }
        }
        for (AnnotationInstance definition : index.getAnnotations(JMS_CONNECTION_FACTORY_DEFINITION)) {
            target = definition.target();
            if (!(target instanceof ClassInfo)) {
                throw EeLogger.ROOT_LOGGER.classOnlyAnnotation(JMS_CONNECTION_FACTORY_DEFINITION.toString(), target);
            }
            this.processJMSConnectionFactoryDefinition(deploymentUnit, eeModuleDescription, definition, (ClassInfo)target, applicationClasses, propertyReplacer);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processJMSDestinationDefinition(DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, AnnotationInstance destinationDefinition, ClassInfo target, EEApplicationClasses applicationClasses, PropertyReplacer propertyReplacer) {
        AnnotationValue nameValue = destinationDefinition.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.annotationAttributeMissing(JMS_DESTINATION_DEFINITION.toString(), "name");
        }
        AnnotationValue interfaceNameValue = destinationDefinition.value("interfaceName");
        if (interfaceNameValue == null || interfaceNameValue.asString().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.annotationAttributeMissing(JMS_DESTINATION_DEFINITION.toString(), "interfaceName");
        }
        DirectJMSDestinationInjectionSource source = new DirectJMSDestinationInjectionSource(nameValue.asString(), interfaceNameValue.asString());
        source.setDestinationName(MessagingJMSDefinitionAnnotationParser.asString(destinationDefinition, "destinationName", propertyReplacer));
        for (String fullProp : MessagingJMSDefinitionAnnotationParser.asArray(destinationDefinition, "properties")) {
            String[] prop = fullProp.split("=", 2);
            String name = propertyReplacer.replaceProperties(prop[0]);
            String value = propertyReplacer.replaceProperties(prop[1]);
            source.addProperty(name, value);
        }
        BindingConfiguration config = new BindingConfiguration(nameValue.asString(), (InjectionSource)source);
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) || DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
            eeModuleDescription.getBindingConfigurations().add(config);
        }
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(target.name().toString());
        classDescription.getBindingConfigurations().add(config);
    }

    private void processJMSConnectionFactoryDefinition(DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, AnnotationInstance connectionFactoryDefinition, ClassInfo target, EEApplicationClasses applicationClasses, PropertyReplacer propertyReplacer) {
        AnnotationValue nameValue = connectionFactoryDefinition.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.annotationAttributeMissing(JMS_CONNECTION_FACTORY_DEFINITION.toString(), "name");
        }
        DirectJMSConnectionFactoryInjectionSource source = new DirectJMSConnectionFactoryInjectionSource(nameValue.asString());
        source.setInterfaceName(MessagingJMSDefinitionAnnotationParser.asString(connectionFactoryDefinition, "interfaceName", ConnectionFactory.class.getName(), propertyReplacer));
        source.setResourceAdapter(MessagingJMSDefinitionAnnotationParser.asString(connectionFactoryDefinition, "resourceAdapter", propertyReplacer));
        source.setUser(MessagingJMSDefinitionAnnotationParser.asString(connectionFactoryDefinition, "user", propertyReplacer));
        source.setPassword(MessagingJMSDefinitionAnnotationParser.asString(connectionFactoryDefinition, "password", propertyReplacer));
        source.setClientId(MessagingJMSDefinitionAnnotationParser.asString(connectionFactoryDefinition, "clientId", propertyReplacer));
        for (String fullProp : MessagingJMSDefinitionAnnotationParser.asArray(connectionFactoryDefinition, "properties")) {
            String[] prop = fullProp.split("=", 2);
            String name = propertyReplacer.replaceProperties(prop[0]);
            String value = propertyReplacer.replaceProperties(prop[1]);
            source.addProperty(name, value);
        }
        source.setTransactional(MessagingJMSDefinitionAnnotationParser.asBoolean(connectionFactoryDefinition, "transactional"));
        source.setMaxPoolSize(MessagingJMSDefinitionAnnotationParser.asInt(connectionFactoryDefinition, "maxPoolSize", ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getDefaultValue().asInt()));
        source.setMinPoolSize(MessagingJMSDefinitionAnnotationParser.asInt(connectionFactoryDefinition, "minPoolSize", ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getDefaultValue().asInt()));
        BindingConfiguration config = new BindingConfiguration(nameValue.asString(), (InjectionSource)source);
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) || DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
            eeModuleDescription.getBindingConfigurations().add(config);
        }
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(target.name().toString());
        classDescription.getBindingConfigurations().add(config);
    }

    private static List<AnnotationInstance> getNestedDefinitionAnnotations(AnnotationInstance definitions) {
        if (definitions == null) {
            return Collections.emptyList();
        }
        AnnotationInstance[] nested = definitions.value().asNestedArray();
        return Arrays.asList(nested);
    }

    private static String asString(AnnotationInstance annotation, String property, PropertyReplacer propertyReplacer) {
        return MessagingJMSDefinitionAnnotationParser.asString(annotation, property, "", propertyReplacer);
    }

    private static String asString(AnnotationInstance annotation, String property, String defaultValue, PropertyReplacer propertyReplacer) {
        AnnotationValue value = annotation.value(property);
        return value == null ? defaultValue : (value.asString().isEmpty() ? defaultValue : propertyReplacer.replaceProperties(value.asString()));
    }

    private static boolean asBoolean(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? true : value.asBoolean();
    }

    private static int asInt(AnnotationInstance annotation, String property, int defaultValue) {
        AnnotationValue value = annotation.value(property);
        return value == null ? defaultValue : value.asInt();
    }

    private static String[] asArray(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? new String[]{} : value.asStringArray();
    }
}

