/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class AbstractUpdateJndiHandler
implements OperationStepHandler {
    private static final String ADD_JNDI = "add-jndi";
    private static final String REMOVE_JNDI = "remove-jndi";
    private static final SimpleAttributeDefinition JNDI_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-binding", ModelType.STRING).setAllowNull(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    private final boolean addOperation;

    protected void registerOperation(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        SimpleOperationDefinition operation = new SimpleOperationDefinition(this.addOperation ? ADD_JNDI : REMOVE_JNDI, resolver, new AttributeDefinition[]{JNDI_BINDING});
        registry.registerOperationHandler((OperationDefinition)operation, (OperationStepHandler)this);
    }

    protected AbstractUpdateJndiHandler(boolean addOperation) {
        this.addOperation = addOperation;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        JNDI_BINDING.validateOperation(operation);
        final String jndiName = JNDI_BINDING.resolveModelAttribute(context, operation).asString();
        ModelNode entries = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get(CommonAttributes.DESTINATION_ENTRIES.getName());
        if (this.addOperation) {
            for (ModelNode entry : entries.asList()) {
                if (!jndiName.equals(entry.asString())) continue;
                throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.jndiNameAlreadyRegistered(jndiName)));
            }
            entries.add(jndiName);
        } else {
            ModelNode updatedEntries = new ModelNode();
            boolean updated = false;
            for (ModelNode entry : entries.asList()) {
                if (jndiName.equals(entry.asString())) {
                    if (entries.asList().size() == 1) {
                        throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.canNotRemoveLastJNDIName(jndiName)));
                    }
                    updated = true;
                    continue;
                }
                updatedEntries.add(entry);
            }
            if (updated) {
                context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get(CommonAttributes.DESTINATION_ENTRIES.getName()).set(updatedEntries);
            }
        }
        if (context.isNormalServer()) {
            if (HornetQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final String resourceName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                    ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
                    ServiceName jmsManagerServiceName = JMSServices.getJmsManagerBaseServiceName(hqServiceName);
                    final ServiceController jmsServerService = context.getServiceRegistry(false).getService(jmsManagerServiceName);
                    if (jmsServerService != null) {
                        JMSServerManager jmsServerManager = (JMSServerManager)JMSServerManager.class.cast(jmsServerService.getValue());
                        if (jmsServerManager == null) {
                            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
                        }
                        try {
                            if (AbstractUpdateJndiHandler.this.addOperation) {
                                AbstractUpdateJndiHandler.this.addJndiName(jmsServerManager, resourceName, jndiName);
                            } else {
                                AbstractUpdateJndiHandler.this.removeJndiName(jmsServerManager, resourceName, jndiName);
                            }
                        }
                        catch (Exception e) {
                            context.getFailureDescription().set(e.getLocalizedMessage());
                        }
                    }
                    if (!context.hasFailureDescription()) {
                        context.getResult();
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            if (jmsServerService != null) {
                                JMSServerManager jmsServerManager = (JMSServerManager)JMSServerManager.class.cast(jmsServerService.getValue());
                                try {
                                    if (AbstractUpdateJndiHandler.this.addOperation) {
                                        AbstractUpdateJndiHandler.this.removeJndiName(jmsServerManager, resourceName, jndiName);
                                    } else {
                                        AbstractUpdateJndiHandler.this.addJndiName(jmsServerManager, resourceName, jndiName);
                                    }
                                }
                                catch (Exception e) {
                                    context.getFailureDescription().set(e.getLocalizedMessage());
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    protected abstract void addJndiName(JMSServerManager var1, String var2, String var3) throws Exception;

    protected abstract void removeJndiName(JMSServerManager var1, String var2, String var3) throws Exception;
}

