/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ClusterConnectionAdd
extends AbstractAddStepHandler {
    public static final ClusterConnectionAdd INSTANCE = new ClusterConnectionAdd();

    private ClusterConnectionAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        AlternativeAttributeCheckHandler.checkAlternatives(operation, ClusterConnectionDefinition.CONNECTOR_REFS.getName(), ClusterConnectionDefinition.DISCOVERY_GROUP_NAME.getName(), true);
        for (AttributeDefinition attributeDefinition : ClusterConnectionDefinition.ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            context.reloadRequired();
        }
    }

    static void addClusterConnectionConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("cluster-connection")) {
            List configs = configuration.getClusterConfigurations();
            for (Property prop : model.get("cluster-connection").asPropertyList()) {
                configs.add(ClusterConnectionAdd.createClusterConnectionConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static ClusterConnectionConfiguration createClusterConnectionConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String address = ClusterConnectionDefinition.ADDRESS.resolveModelAttribute(context, model).asString();
        String connectorName = ClusterConnectionDefinition.CONNECTOR_REF.resolveModelAttribute(context, model).asString();
        long retryInterval = ClusterConnectionDefinition.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        boolean duplicateDetection = ClusterConnectionDefinition.USE_DUPLICATE_DETECTION.resolveModelAttribute(context, model).asBoolean();
        long connectionTTL = ClusterConnectionDefinition.CONNECTION_TTL.resolveModelAttribute(context, model).asInt();
        int initialConnectAttempts = ClusterConnectionDefinition.INITIAL_CONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        int reconnectAttempts = ClusterConnectionDefinition.RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        long maxRetryInterval = ClusterConnectionDefinition.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        double retryIntervalMultiplier = ClusterConnectionDefinition.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble();
        long clientFailureCheckPeriod = ClusterConnectionDefinition.CHECK_PERIOD.resolveModelAttribute(context, model).asInt();
        boolean forwardWhenNoConsumers = ClusterConnectionDefinition.FORWARD_WHEN_NO_CONSUMERS.resolveModelAttribute(context, model).asBoolean();
        int maxHops = ClusterConnectionDefinition.MAX_HOPS.resolveModelAttribute(context, model).asInt();
        int confirmationWindowSize = CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt();
        ModelNode discoveryNode = ClusterConnectionDefinition.DISCOVERY_GROUP_NAME.resolveModelAttribute(context, model);
        String discoveryGroupName = discoveryNode.isDefined() ? discoveryNode.asString() : null;
        List<String> staticConnectors = discoveryGroupName == null ? ClusterConnectionAdd.getStaticConnectors(model) : null;
        boolean allowDirectOnly = ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY.resolveModelAttribute(context, model).asBoolean();
        int minLargeMessageSize = CommonAttributes.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt();
        long callTimeout = CommonAttributes.CALL_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long callFailoverTimeout = CommonAttributes.CALL_FAILOVER_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long clusterNotificationInterval = ClusterConnectionDefinition.NOTIFICATION_INTERVAL.resolveModelAttribute(context, model).asLong();
        int clusterNotificationAttempts = ClusterConnectionDefinition.NOTIFICATION_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        if (discoveryGroupName != null) {
            return new ClusterConnectionConfiguration(name, address, connectorName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, retryIntervalMultiplier, maxRetryInterval, initialConnectAttempts, reconnectAttempts, callTimeout, callFailoverTimeout, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, discoveryGroupName, clusterNotificationInterval, clusterNotificationAttempts);
        }
        return new ClusterConnectionConfiguration(name, address, connectorName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, retryIntervalMultiplier, maxRetryInterval, initialConnectAttempts, reconnectAttempts, callTimeout, callFailoverTimeout, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, staticConnectors, allowDirectOnly, clusterNotificationInterval, clusterNotificationAttempts);
    }

    private static List<String> getStaticConnectors(ModelNode model) {
        if (!model.hasDefined("static-connectors")) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ModelNode connector : model.require("static-connectors").asList()) {
            result.add(connector.asString());
        }
        return result;
    }
}

