/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HTTPConnectorDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.TransportParamDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class TransportConfigOperationHandlers {
    TransportConfigOperationHandlers() {
    }

    static void processAcceptors(OperationContext context, Configuration configuration, ModelNode params, Set<String> bindings) throws OperationFailedException {
        Map<String, Object> parameters;
        ModelNode config;
        String acceptorName;
        HashMap<String, TransportConfiguration> acceptors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("acceptor")) {
            for (Property property : params.get("acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                String clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                acceptors.put(acceptorName, new TransportConfiguration(clazz, parameters, acceptorName));
            }
        }
        if (params.hasDefined("remote-acceptor")) {
            for (Property property : params.get("remote-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                String binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                bindings.add(binding);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        if (params.hasDefined("in-vm-acceptor")) {
            for (Property property : params.get("in-vm-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                parameters.put(InVMTransportDefinition.SERVER_ID.getName(), InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, config).asInt());
                acceptors.put(acceptorName, new TransportConfiguration(InVMAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        if (params.hasDefined("http-acceptor")) {
            for (Property property : params.get("http-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                parameters.put("http-upgrade-enabled", true);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName));
            }
        }
        configuration.setAcceptorConfigurations(new HashSet(acceptors.values()));
    }

    static Map<String, Object> getParameters(OperationContext context, ModelNode config) throws OperationFailedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (config.hasDefined("param")) {
            for (Property parameter : config.get("param").asPropertyList()) {
                String name = parameter.getName();
                String value = TransportParamDefinition.VALUE.resolveModelAttribute(context, parameter.getValue()).asString();
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    static void processConnectors(OperationContext context, Configuration configuration, ModelNode params, Set<String> bindings) throws OperationFailedException {
        String binding;
        Map<String, Object> parameters;
        ModelNode config;
        String connectorName;
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("connector")) {
            for (Property property : params.get("connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                String clazz = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, config).asString();
                connectors.put(connectorName, new TransportConfiguration(clazz, parameters, connectorName));
            }
        }
        if (params.hasDefined("remote-connector")) {
            for (Property property : params.get("remote-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                bindings.add(binding);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        if (params.hasDefined("in-vm-connector")) {
            for (Property property : params.get("in-vm-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                parameters.put(InVMTransportDefinition.SERVER_ID.getName(), InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, config).asInt());
                connectors.put(connectorName, new TransportConfiguration(InVMConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        if (params.hasDefined("http-connector")) {
            for (Property property : params.get("http-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config);
                binding = HTTPConnectorDefinition.SOCKET_BINDING.resolveModelAttribute(context, config).asString();
                bindings.add(binding);
                parameters.put(HTTPConnectorDefinition.SOCKET_BINDING.getName(), binding);
                parameters.put("http-upgrade-enabled", true);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName));
            }
        }
        configuration.setConnectorConfigurations(connectors);
    }
}

