/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.extension.metrics.MetricID;
import org.wildfly.extension.metrics.MetricMetadata;

public class WildFlyMetricMetadata
implements MetricMetadata {
    private static final Pattern SNAKE_CASE_PATTERN = Pattern.compile("(?<=[a-z])[A-Z]");
    private final String description;
    private final MeasurementUnit unit;
    private final MetricMetadata.Type type;
    private final String attributeName;
    private final PathAddress address;
    private final String globalPrefix;
    private String metricName;
    private MetricMetadata.MetricTag[] tags;
    private MetricID metricID;

    public WildFlyMetricMetadata(String attributeName, PathAddress address, String prefix, String description, MeasurementUnit unit, MetricMetadata.Type type) {
        Objects.requireNonNull(attributeName);
        Objects.requireNonNull(address);
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(description);
        Objects.requireNonNull(type);
        this.attributeName = attributeName;
        this.address = address;
        this.globalPrefix = prefix;
        this.description = description;
        this.unit = unit != null ? unit : MeasurementUnit.NONE;
        this.type = type;
        this.init();
    }

    private void init() {
        String metricPrefix = "";
        ArrayList<String> labelNames = new ArrayList<String>();
        ArrayList<String> labelValues = new ArrayList<String>();
        for (PathElement element : this.address) {
            String key = element.getKey();
            String value = element.getValue();
            if (key.equals("subsystem") || key.equals("statistics")) {
                metricPrefix = metricPrefix + value + "-";
                continue;
            }
            labelNames.add(WildFlyMetricMetadata.getPrometheusMetricName(key));
            labelValues.add(value);
        }
        if (labelNames.contains("deployment") && !labelNames.contains("subdeployment")) {
            labelNames.add("subdeployment");
            labelValues.add((String)labelValues.get(labelNames.indexOf("deployment")));
        }
        if (this.globalPrefix != null && !this.globalPrefix.isEmpty()) {
            metricPrefix = this.globalPrefix + "-" + metricPrefix;
        }
        this.metricName = WildFlyMetricMetadata.getPrometheusMetricName(metricPrefix + this.attributeName);
        this.tags = new MetricMetadata.MetricTag[labelNames.size()];
        for (int i = 0; i < labelNames.size(); ++i) {
            String name = (String)labelNames.get(i);
            String value = (String)labelValues.get(i);
            this.tags[i] = new MetricMetadata.MetricTag(name, value);
        }
        this.metricID = new MetricID(this.metricName, this.tags);
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public MetricMetadata.MetricTag[] getTags() {
        return this.tags;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public MeasurementUnit getMeasurementUnit() {
        return this.unit;
    }

    @Override
    public MetricMetadata.Type getType() {
        return this.type;
    }

    @Override
    public MetricID getMetricID() {
        return this.metricID;
    }

    static String getPrometheusMetricName(String name) {
        name = name.replaceAll("[^\\w]+", "_");
        name = WildFlyMetricMetadata.decamelize(name);
        return name;
    }

    private static String decamelize(String in) {
        Matcher m = SNAKE_CASE_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + m.group().toLowerCase());
        }
        m.appendTail(sb);
        return sb.toString().toLowerCase();
    }
}

