/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.jmx.JmxMicrometerCollector;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerRegistryService
implements Service {
    private final Consumer<WildFlyRegistry> registriesConsumer;

    static Supplier<WildFlyRegistry> install(OperationContext context) {
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY);
        RegistrySupplier registrySupplier = new RegistrySupplier(serviceBuilder.provides(new ServiceName[]{MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName()}));
        serviceBuilder.setInstance((Service)new MicrometerRegistryService(registrySupplier)).install();
        return registrySupplier;
    }

    private MicrometerRegistryService(Consumer<WildFlyRegistry> registriesConsumer) {
        this.registriesConsumer = registriesConsumer;
    }

    public void start(StartContext context) {
        WildFlyRegistry registry = new WildFlyRegistry();
        try {
            new JmxMicrometerCollector(registry).init();
        }
        catch (IOException e) {
            throw MicrometerExtensionLogger.MICROMETER_LOGGER.failedInitializeJMXRegistrar(e);
        }
        this.registriesConsumer.accept(registry);
    }

    public void stop(StopContext context) {
        this.registriesConsumer.accept(null);
    }

    private static final class RegistrySupplier
    implements Consumer<WildFlyRegistry>,
    Supplier<WildFlyRegistry> {
        private final Consumer<WildFlyRegistry> wrapped;
        private volatile WildFlyRegistry registry;

        private RegistrySupplier(Consumer<WildFlyRegistry> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void accept(WildFlyRegistry registry) {
            this.registry = registry;
            this.wrapped.accept(registry);
        }

        @Override
        public WildFlyRegistry get() {
            return this.registry;
        }
    }
}

