/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.HistogramFlavor;
import io.micrometer.registry.otlp.OtlpConfig;
import java.security.AccessController;
import java.time.Duration;
import java.util.Map;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class WildFlyMicrometerConfig
implements OtlpConfig {
    private final String endpoint;
    private final Long step;

    public WildFlyMicrometerConfig(String endpoint, Long step) {
        this.endpoint = endpoint;
        this.step = step;
    }

    public String get(String key) {
        return null;
    }

    public Map<String, String> resourceAttributes() {
        Map attributes = super.resourceAttributes();
        if (!attributes.containsKey("service.name")) {
            attributes.put("service.name", "wildfly");
        }
        return attributes;
    }

    public String url() {
        return this.endpoint;
    }

    public Duration step() {
        return Duration.ofSeconds(this.step);
    }

    public AggregationTemporality aggregationTemporality() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> super.aggregationTemporality());
        }
        return super.aggregationTemporality();
    }

    public HistogramFlavor histogramFlavor() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> super.histogramFlavor());
        }
        return super.histogramFlavor();
    }

    public Map<String, String> headers() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> super.headers());
        }
        return super.headers();
    }
}

