/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collection;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JDBCProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketBindingProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.XMLAttribute;
import org.jboss.as.clustering.jgroups.subsystem.XMLElement;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JGroupsSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(JGroupsSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            if (model.hasDefined(ChannelResourceDefinition.WILDCARD_PATH.getKey())) {
                writer.writeStartElement(XMLElement.CHANNELS.getLocalName());
                JGroupsSubsystemXMLWriter.writeAttribute(writer, model, JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL);
                for (Property property : model.get(ChannelResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    writer.writeStartElement(XMLElement.CHANNEL.getLocalName());
                    writer.writeAttribute(XMLAttribute.NAME.getLocalName(), property.getName());
                    ModelNode channel = property.getValue();
                    JGroupsSubsystemXMLWriter.writeAttributes(writer, channel, ChannelResourceDefinition.Attribute.class);
                    if (channel.hasDefined(ForkResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property forkProperty : channel.get(ForkResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            writer.writeStartElement(XMLElement.FORK.getLocalName());
                            writer.writeAttribute(XMLAttribute.NAME.getLocalName(), forkProperty.getName());
                            ModelNode fork = forkProperty.getValue();
                            if (fork.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                                for (Property protocol : fork.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                                    JGroupsSubsystemXMLWriter.writeProtocol(writer, protocol);
                                }
                            }
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (model.hasDefined(StackResourceDefinition.WILDCARD_PATH.getKey())) {
                writer.writeStartElement(XMLElement.STACKS.getLocalName());
                JGroupsSubsystemXMLWriter.writeAttribute(writer, model, JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK);
                for (Property property : model.get(StackResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    writer.writeStartElement(XMLElement.STACK.getLocalName());
                    writer.writeAttribute(XMLAttribute.NAME.getLocalName(), property.getName());
                    ModelNode stack = property.getValue();
                    JGroupsSubsystemXMLWriter.writeAttributes(writer, stack, StackResourceDefinition.Attribute.class);
                    if (stack.hasDefined(TransportResourceDefinition.WILDCARD_PATH.getKey())) {
                        JGroupsSubsystemXMLWriter.writeTransport(writer, stack.get(TransportResourceDefinition.WILDCARD_PATH.getKey()).asProperty());
                    }
                    if (stack.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property protocol : stack.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            JGroupsSubsystemXMLWriter.writeProtocol(writer, protocol);
                        }
                    }
                    if (stack.get(RelayResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
                        JGroupsSubsystemXMLWriter.writeRelay(writer, stack.get(RelayResourceDefinition.PATH.getKeyValuePair()));
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeTransport(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(XMLElement.TRANSPORT.getLocalName());
        JGroupsSubsystemXMLWriter.writeGenericProtocolAttributes(writer, property);
        ModelNode transport = property.getValue();
        JGroupsSubsystemXMLWriter.writeAttributes(writer, transport, SocketBindingProtocolResourceDefinition.Attribute.class);
        JGroupsSubsystemXMLWriter.writeAttributes(writer, transport, TransportResourceDefinition.Attribute.class);
        JGroupsSubsystemXMLWriter.writeAttributes(writer, transport, TransportResourceDefinition.ThreadingAttribute.class);
        JGroupsSubsystemXMLWriter.writeElement(writer, transport, AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
        if (transport.hasDefined(ThreadPoolResourceDefinition.WILDCARD_PATH.getKey())) {
            JGroupsSubsystemXMLWriter.writeThreadPoolElements(XMLElement.DEFAULT_THREAD_POOL, ThreadPoolResourceDefinition.DEFAULT, writer, transport);
            JGroupsSubsystemXMLWriter.writeThreadPoolElements(XMLElement.INTERNAL_THREAD_POOL, ThreadPoolResourceDefinition.INTERNAL, writer, transport);
            JGroupsSubsystemXMLWriter.writeThreadPoolElements(XMLElement.OOB_THREAD_POOL, ThreadPoolResourceDefinition.OOB, writer, transport);
            JGroupsSubsystemXMLWriter.writeThreadPoolElements(XMLElement.TIMER_THREAD_POOL, ThreadPoolResourceDefinition.TIMER, writer, transport);
        }
        writer.writeEndElement();
    }

    private static void writeProtocol(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(XMLElement.forProtocol(property.getName()).getLocalName());
        JGroupsSubsystemXMLWriter.writeProtocolAttributes(writer, property);
        JGroupsSubsystemXMLWriter.writeElement(writer, property.getValue(), AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
        writer.writeEndElement();
    }

    private static void writeGenericProtocolAttributes(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeAttribute(XMLAttribute.TYPE.getLocalName(), property.getName());
        JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.complementOf(EnumSet.of(AbstractProtocolResourceDefinition.Attribute.PROPERTIES)));
    }

    private static void writeProtocolAttributes(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        JGroupsSubsystemXMLWriter.writeGenericProtocolAttributes(writer, property);
        if (ProtocolRegistration.ProtocolType.MULTICAST_SOCKET.contains(property.getName())) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.allOf(SocketBindingProtocolResourceDefinition.Attribute.class));
        } else if (ProtocolRegistration.ProtocolType.JDBC.contains(property.getName())) {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.allOf(JDBCProtocolResourceDefinition.Attribute.class));
        } else if (ProtocolRegistration.ProtocolType.ENCRYPT.contains(property.getName())) {
            EnumSet<EncryptProtocolResourceDefinition.Attribute> elementAttributes = EnumSet.of(EncryptProtocolResourceDefinition.Attribute.CREDENTIAL);
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.complementOf(elementAttributes));
            if (JGroupsSubsystemXMLWriter.hasDefined(property.getValue(), elementAttributes)) {
                for (Attribute attribute : elementAttributes) {
                    JGroupsSubsystemXMLWriter.writeElement(writer, property.getValue(), attribute);
                }
            }
        } else {
            JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.allOf(ProtocolResourceDefinition.DeprecatedAttribute.class));
        }
    }

    private static void writeThreadPoolElements(XMLElement element, ThreadPoolResourceDefinition pool, XMLExtendedStreamWriter writer, ModelNode transport) throws XMLStreamException {
        ModelNode threadPool;
        PathElement path = pool.getPathElement();
        if (transport.get(path.getKey()).hasDefined(path.getValue()) && JGroupsSubsystemXMLWriter.hasDefined(threadPool = transport.get(path.getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            JGroupsSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }

    private static void writeRelay(XMLExtendedStreamWriter writer, ModelNode relay) throws XMLStreamException {
        writer.writeStartElement(XMLElement.RELAY.getLocalName());
        JGroupsSubsystemXMLWriter.writeAttributes(writer, relay, RelayResourceDefinition.Attribute.class);
        if (relay.hasDefined(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(XMLElement.REMOTE_SITE.getLocalName());
                writer.writeAttribute(XMLAttribute.NAME.getLocalName(), property.getName());
                JGroupsSubsystemXMLWriter.writeAttributes(writer, property.getValue(), EnumSet.allOf(RemoteSiteResourceDefinition.Attribute.class));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static boolean hasDefined(ModelNode model, Collection<? extends Attribute> attributes) {
        return attributes.stream().anyMatch(attribute -> model.hasDefined(attribute.getName()));
    }

    private static <A extends Enum<A>> void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Class<A> attributeClass) throws XMLStreamException {
        JGroupsSubsystemXMLWriter.writeAttributes(writer, model, EnumSet.allOf(attributeClass));
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Collection<? extends Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            JGroupsSubsystemXMLWriter.writeAttribute(writer, model, attribute);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }

    private static void writeElement(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getAttributeMarshaller().marshallAsElement((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }
}

