/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.jboss.logging.Logger;

public class FileStoreMonitor
extends ActiveMQScheduledComponent {
    private static final Logger logger = Logger.getLogger(FileStoreMonitor.class);
    private final Set<Callback> callbackList = new HashSet<Callback>();
    private final Set<FileStore> stores = new HashSet<FileStore>();
    private double maxUsage;

    public FileStoreMonitor(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, double maxUsage) {
        super(scheduledExecutorService, executor, checkPeriod, timeUnit, false);
        this.maxUsage = maxUsage;
    }

    public synchronized FileStoreMonitor addCallback(Callback callback) {
        this.callbackList.add(callback);
        return this;
    }

    public synchronized FileStoreMonitor addStore(File file) throws IOException {
        if (file != null && file.exists()) {
            this.addStore(Files.getFileStore(file.toPath()));
        }
        return this;
    }

    public synchronized FileStoreMonitor addStore(FileStore store) {
        this.stores.add(store);
        return this;
    }

    public void run() {
        this.tick();
    }

    public synchronized void tick() {
        boolean over = false;
        FileStore lastStore = null;
        double usage = 0.0;
        for (FileStore store : this.stores) {
            try {
                lastStore = store;
                usage = this.calculateUsage(store);
                over = usage > this.maxUsage;
                if (!over) continue;
                break;
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (Callback callback : this.callbackList) {
            callback.tick(lastStore, usage);
            if (over) {
                callback.over(lastStore, usage);
                continue;
            }
            callback.under(lastStore, usage);
        }
    }

    public double getMaxUsage() {
        return this.maxUsage;
    }

    public FileStoreMonitor setMaxUsage(double maxUsage) {
        this.maxUsage = maxUsage;
        return this;
    }

    protected double calculateUsage(FileStore store) throws IOException {
        return 1.0 - (double)store.getUsableSpace() / (double)store.getTotalSpace();
    }

    public static interface Callback {
        public void tick(FileStore var1, double var2);

        public void over(FileStore var1, double var2);

        public void under(FileStore var1, double var2);
    }
}

