/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;

class WebsocketsDefinition
extends PersistentResourceDefinition {
    static final WebsocketsDefinition INSTANCE = new WebsocketsDefinition();
    protected static final SimpleAttributeDefinition BUFFER_POOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("buffer-pool", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode("default"))).build();
    protected static final SimpleAttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode("default"))).build();
    protected static final SimpleAttributeDefinition DISPATCH_TO_WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dispatch-to-worker", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    protected static final SimpleAttributeDefinition PER_MESSAGE_DEFLATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("per-message-deflate", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition DEFLATER_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("deflater-level", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, 9, true, true))).setDefaultValue(new ModelNode(0))).build();
    protected static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{BUFFER_POOL, WORKER, DISPATCH_TO_WORKER, PER_MESSAGE_DEFLATE, DEFLATER_LEVEL};
    static final Map<String, AttributeDefinition> ATTRIBUTES_MAP = new HashMap<String, AttributeDefinition>();

    private WebsocketsDefinition() {
        super(UndertowExtension.PATH_WEBSOCKETS, (ResourceDescriptionResolver)UndertowExtension.getResolver(UndertowExtension.PATH_WEBSOCKETS.getKeyValuePair()), (OperationStepHandler)new WebsocketsAdd(), (OperationStepHandler)new WebsocketsRemove());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_MAP.values();
    }

    public WebSocketInfo getConfig(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        boolean dispatchToWorker = DISPATCH_TO_WORKER.resolveModelAttribute(context, model).asBoolean();
        String bufferPool = BUFFER_POOL.resolveModelAttribute(context, model).asString();
        String worker = WORKER.resolveModelAttribute(context, model).asString();
        boolean perMessageDeflate = PER_MESSAGE_DEFLATE.resolveModelAttribute(context, model).asBoolean();
        int deflaterLevel = DEFLATER_LEVEL.resolveModelAttribute(context, model).asInt();
        return new WebSocketInfo(worker, bufferPool, dispatchToWorker, perMessageDeflate, deflaterLevel);
    }

    static {
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            ATTRIBUTES_MAP.put(attr.getName(), (AttributeDefinition)attr);
        }
    }

    public static class WebSocketInfo {
        private final String worker;
        private final String bufferPool;
        private final boolean dispatchToWorker;
        private final boolean perMessageDeflate;
        private final int deflaterLevel;

        public WebSocketInfo(String worker, String bufferPool, boolean dispatchToWorker, boolean perMessageDeflate, int deflaterLevel) {
            this.worker = worker;
            this.bufferPool = bufferPool;
            this.dispatchToWorker = dispatchToWorker;
            this.perMessageDeflate = perMessageDeflate;
            this.deflaterLevel = deflaterLevel;
        }

        public String getWorker() {
            return this.worker;
        }

        public String getBufferPool() {
            return this.bufferPool;
        }

        public boolean isDispatchToWorker() {
            return this.dispatchToWorker;
        }

        public boolean isPerMessageDeflate() {
            return this.perMessageDeflate;
        }

        public int getDeflaterLevel() {
            return this.deflaterLevel;
        }
    }

    private static class WebsocketsRemove
    extends RestartParentResourceRemoveHandler {
        protected WebsocketsRemove() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }

    private static class WebsocketsAdd
    extends RestartParentResourceAddHandler {
        protected WebsocketsAdd() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (SimpleAttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }
}

