/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.common.Assert;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ConfiguredProvider;
import org.wildfly.discovery.InvalidDiscoveryConfigurationException;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.impl.AggregateRegistryProvider;
import org.wildfly.discovery.impl.LocalRegistryAndDiscoveryProvider;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.ExternalDiscoveryConfigurator;
import org.wildfly.discovery.spi.RegistryProvider;

final class DiscoveryXmlParser {
    private static final DiscoveryProvider[] NO_DISCOVERY_PROVIDERS = new DiscoveryProvider[0];
    private static final RegistryProvider[] NO_REGISTRY_PROVIDERS = new RegistryProvider[0];
    static final String NS_DISCOVERY_1_0 = "urn:wildfly-discovery:1.0";

    private DiscoveryXmlParser() {
    }

    static ConfiguredProvider getConfiguredProvider() {
        ArrayList<DiscoveryProvider> discoveryProviders = new ArrayList<DiscoveryProvider>();
        ArrayList<RegistryProvider> registryProviders = new ArrayList<RegistryProvider>();
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_DISCOVERY_1_0));){
                DiscoveryXmlParser.parseConfiguration(streamReader, discoveryProviders, registryProviders);
            }
            catch (ConfigXMLParseException e) {
                throw new InvalidDiscoveryConfigurationException(e);
            }
        }
        ServiceLoader<ExternalDiscoveryConfigurator> loader = ServiceLoader.load(ExternalDiscoveryConfigurator.class);
        Iterator<ExternalDiscoveryConfigurator> iterator = loader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    ExternalDiscoveryConfigurator configurator = iterator.next();
                    configurator.configure(provider -> discoveryProviders.add(Assert.checkNotNullParam("provider", provider)), provider -> registryProviders.add(Assert.checkNotNullParam("provider", provider)));
                }
            }
            catch (RuntimeException | ServiceConfigurationError configurator) {
                continue;
            }
            break;
        }
        DiscoveryProvider discoveryProvider = discoveryProviders.isEmpty() ? DiscoveryProvider.EMPTY : (discoveryProviders.size() == 1 ? (DiscoveryProvider)discoveryProviders.get(0) : new AggregateDiscoveryProvider(discoveryProviders.toArray(NO_DISCOVERY_PROVIDERS)));
        RegistryProvider registryProvider = registryProviders.isEmpty() ? RegistryProvider.EMPTY : (registryProviders.size() == 1 ? (RegistryProvider)registryProviders.get(0) : new AggregateRegistryProvider(registryProviders.toArray(NO_REGISTRY_PROVIDERS)));
        return new ConfiguredProvider(discoveryProvider, registryProvider);
    }

    private static void parseConfiguration(ConfigurationXMLStreamReader reader, List<DiscoveryProvider> discoveryProviders, List<RegistryProvider> registryProviders) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            switch (tag) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "discovery": {
                            DiscoveryXmlParser.parseDiscoveryElement(reader, discoveryProviders, registryProviders);
                            return;
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
            throw reader.unexpectedContent();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseDiscoveryElement(ConfigurationXMLStreamReader reader, List<DiscoveryProvider> discoveryProviders, List<RegistryProvider> registryProviders) throws ConfigXMLParseException {
        DiscoveryProvider discoveryProvider = DiscoveryProvider.EMPTY;
        RegistryProvider registryProvider = RegistryProvider.EMPTY;
        LocalRegistryAndDiscoveryProvider localRegistry = new LocalRegistryAndDiscoveryProvider();
        DiscoveryXmlParser.requireNoAttributes(reader);
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            block0 : switch (tag) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "discovery-provider": {
                            if (discoveryProvider != DiscoveryProvider.EMPTY) {
                                throw reader.unexpectedElement();
                            }
                            discoveryProviders.add(DiscoveryXmlParser.parseDiscoveryProvider(reader, localRegistry));
                            break block0;
                        }
                        case "registry-provider": {
                            if (registryProvider != RegistryProvider.EMPTY) {
                                throw reader.unexpectedElement();
                            }
                            registryProviders.add(DiscoveryXmlParser.parseRegistryProvider(reader, localRegistry));
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static RegistryProvider parseRegistryProvider(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        int tag = reader.nextTag();
        switch (tag) {
            case 1: {
                RegistryProvider registryProvider;
                DiscoveryXmlParser.checkNamespace(reader);
                switch (reader.getLocalName()) {
                    case "local-registry": {
                        registryProvider = localRegistry;
                        DiscoveryXmlParser.expectEnd(reader);
                        break;
                    }
                    case "aggregate": {
                        registryProvider = DiscoveryXmlParser.parseAggregateRegistry(reader, localRegistry);
                        break;
                    }
                    case "custom": {
                        registryProvider = DiscoveryXmlParser.parseCustom(reader, RegistryProvider.class);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                DiscoveryXmlParser.expectEnd(reader);
                return registryProvider;
            }
        }
        throw reader.unexpectedElement();
    }

    private static DiscoveryProvider parseDiscoveryProvider(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        int tag = reader.nextTag();
        switch (tag) {
            case 1: {
                DiscoveryProvider discoveryProvider;
                DiscoveryXmlParser.checkNamespace(reader);
                switch (reader.getLocalName()) {
                    case "local-registry": {
                        discoveryProvider = localRegistry;
                        DiscoveryXmlParser.expectEnd(reader);
                        break;
                    }
                    case "static": {
                        discoveryProvider = DiscoveryXmlParser.parseStatic(reader);
                        break;
                    }
                    case "aggregate": {
                        discoveryProvider = DiscoveryXmlParser.parseAggregateDiscovery(reader, localRegistry);
                        break;
                    }
                    case "custom": {
                        discoveryProvider = DiscoveryXmlParser.parseCustom(reader, DiscoveryProvider.class);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                DiscoveryXmlParser.expectEnd(reader);
                return discoveryProvider;
            }
        }
        throw reader.missingRequiredElement(NS_DISCOVERY_1_0, "local-registry/static/aggregate/custom");
    }

    private static DiscoveryProvider parseAggregateDiscovery(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        ArrayList<DiscoveryProvider> delegates = new ArrayList<DiscoveryProvider>();
        block10: while (reader.hasNext()) {
            int tag = reader.nextTag();
            switch (tag) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "discovery-provider": {
                            delegates.add(DiscoveryXmlParser.parseDiscoveryProvider(reader, localRegistry));
                            break block10;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        return new AggregateDiscoveryProvider(delegates.toArray(NO_DISCOVERY_PROVIDERS));
    }

    private static RegistryProvider parseAggregateRegistry(ConfigurationXMLStreamReader reader, LocalRegistryAndDiscoveryProvider localRegistry) throws ConfigXMLParseException {
        DiscoveryXmlParser.requireNoAttributes(reader);
        ArrayList<RegistryProvider> delegates = new ArrayList<RegistryProvider>();
        block10: while (reader.hasNext()) {
            int tag = reader.nextTag();
            switch (tag) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "registry-provider": {
                            delegates.add(DiscoveryXmlParser.parseRegistryProvider(reader, localRegistry));
                            break block10;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        return new AggregateRegistryProvider(delegates.toArray(NO_REGISTRY_PROVIDERS));
    }

    private static DiscoveryProvider parseStatic(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ArrayList<ServiceURL> serviceURLs = new ArrayList<ServiceURL>();
        DiscoveryXmlParser.requireNoAttributes(reader);
        block10: while (reader.hasNext()) {
            int tag = reader.nextTag();
            switch (tag) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "service": {
                            serviceURLs.add(DiscoveryXmlParser.parseService(reader));
                            break block10;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        return new StaticDiscoveryProvider(serviceURLs);
    }

    private static void requireNoAttributes(ConfigurationXMLStreamReader reader) {
        if (reader.getAttributeCount() > 0) {
            reader.unexpectedAttribute(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ServiceURL parseService(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ServiceURL.Builder builder = new ServiceURL.Builder();
        URI uri = null;
        String uriSchemeAuthority = null;
        String abstractType = null;
        String abstractTypeAuthority = null;
        int cnt = reader.getAttributeCount();
        block22: for (int i = 0; i < cnt; ++i) {
            DiscoveryXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "uri": {
                    uri = reader.getURIAttributeValue(i);
                    continue block22;
                }
                case "uri-scheme-authority": {
                    uriSchemeAuthority = reader.getAttributeValue(i);
                    continue block22;
                }
                case "abstract-type": {
                    abstractType = reader.getAttributeValue(i);
                    continue block22;
                }
                case "abstract-type-authority": {
                    abstractTypeAuthority = reader.getAttributeValue(i);
                    continue block22;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (uri == null) {
            throw reader.missingRequiredAttribute(null, "uri");
        }
        builder.setUri(uri);
        if (uriSchemeAuthority != null) {
            builder.setUriSchemeAuthority(uriSchemeAuthority);
        }
        if (abstractType != null) {
            builder.setAbstractType(abstractType);
        }
        if (abstractTypeAuthority != null) {
            builder.setAbstractTypeAuthority(abstractTypeAuthority);
        }
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            block12 : switch (tag) {
                case 1: {
                    DiscoveryXmlParser.checkNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "attribute": {
                            DiscoveryXmlParser.parseAttribute(reader, builder);
                            break block12;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return builder.create();
                }
            }
        }
        return builder.create();
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader, int i) throws ConfigXMLParseException {
        if (reader.getAttributeNamespace(i) != null) {
            throw reader.unexpectedAttribute(i);
        }
    }

    private static void parseAttribute(ConfigurationXMLStreamReader reader, ServiceURL.Builder builder) throws ConfigXMLParseException {
        String name = null;
        AttributeValue value = null;
        int cnt = reader.getAttributeCount();
        block8: for (int i = 0; i < cnt; ++i) {
            DiscoveryXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block8;
                }
                case "value": {
                    value = AttributeValue.fromString(reader.getAttributeValue(i));
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (name == null) {
            throw reader.missingRequiredAttribute(null, "name");
        }
        DiscoveryXmlParser.expectEnd(reader);
        if (value == null) {
            builder.addAttribute(name);
        } else {
            builder.addAttribute(name, value);
        }
    }

    private static void checkNamespace(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        switch (reader.getNamespaceURI()) {
            case "urn:wildfly-discovery:1.0": {
                break;
            }
            default: {
                throw reader.unexpectedElement();
            }
        }
    }

    private static <T> T parseCustom(ConfigurationXMLStreamReader reader, Class<T> type) throws ConfigXMLParseException {
        T item;
        String className = null;
        String moduleName = null;
        int cnt = reader.getAttributeCount();
        block12: for (int i = 0; i < cnt; ++i) {
            DiscoveryXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "class": {
                    className = reader.getAttributeValue(i);
                    continue block12;
                }
                case "module": {
                    moduleName = reader.getAttributeValue(i);
                    continue block12;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (moduleName != null) {
            item = ModuleLoadDelegate.loadService(moduleName, className, type);
        } else {
            if (className != null) {
                try {
                    item = Class.forName(className, true, DiscoveryXmlParser.class.getClassLoader()).asSubclass(type).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new InvalidDiscoveryConfigurationException(e);
                }
            }
            ServiceLoader<T> loader = ServiceLoader.load(type);
            Iterator<T> iterator = loader.iterator();
            try {
                if (!iterator.hasNext()) {
                    throw new InvalidDiscoveryConfigurationException("No provider found");
                }
                item = iterator.next();
            }
            catch (ServiceConfigurationError e) {
                throw new InvalidDiscoveryConfigurationException(e);
            }
        }
        DiscoveryXmlParser.expectEnd(reader);
        return item;
    }

    private static void expectEnd(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
    }

    static final class ModuleLoadDelegate {
        ModuleLoadDelegate() {
        }

        static <T> T loadService(String moduleName, String className, Class<T> type) throws ConfigXMLParseException {
            if (className != null) {
                try {
                    Module.loadClassFromCallerModuleLoader((String)moduleName, (String)className).asSubclass(type).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | ModuleLoadException e) {
                    throw new InvalidDiscoveryConfigurationException(e);
                }
            } else {
                try {
                    ServiceLoader loader = Module.loadServiceFromCallerModuleLoader((String)moduleName, type);
                    Iterator iterator = loader.iterator();
                    try {
                        if (!iterator.hasNext()) {
                            throw new InvalidDiscoveryConfigurationException("No provider found in module " + moduleName);
                        }
                        return (T)iterator.next();
                    }
                    catch (ServiceConfigurationError e) {
                        throw new InvalidDiscoveryConfigurationException(e);
                    }
                }
                catch (ModuleLoadException e) {
                    throw new InvalidDiscoveryConfigurationException(e);
                }
            }
            return null;
        }
    }
}

