/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.ServiceLoader;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.ModuleBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.XAResourceRecoveryBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.CacheBuilderProvider;

public class CacheServiceHandler
implements ResourceServiceHandler {
    private final ResourceServiceBuilderFactory<Configuration> builderFactory;
    private final Class<? extends CacheBuilderProvider> providerClass;

    CacheServiceHandler(ResourceServiceBuilderFactory<Configuration> builderFactory, Class<? extends CacheBuilderProvider> providerClass) {
        this.builderFactory = builderFactory;
        this.providerClass = providerClass;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = context.getCurrentAddress();
        PathAddress containerAddress = cacheAddress.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        ServiceName moduleServiceName = CacheComponent.MODULE.getServiceName(cacheAddress);
        if (model.hasDefined(CacheResourceDefinition.Attribute.MODULE.getName())) {
            new ModuleBuilder(moduleServiceName, (Attribute)CacheResourceDefinition.Attribute.MODULE).configure(context, model).build(target).install();
        } else {
            new AliasServiceBuilder(moduleServiceName, CacheContainerComponent.MODULE.getServiceName(containerAddress), Module.class).build(target).install();
        }
        this.builderFactory.createBuilder(cacheAddress).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        new CacheBuilder(CacheResourceDefinition.Capability.CACHE.getServiceName(cacheAddress), containerName, cacheName).configure(context).build(target).install();
        new XAResourceRecoveryBuilder(cacheAddress).build(target).install();
        new BinderServiceBuilder(InfinispanBindingFactory.createCacheConfigurationBinding(containerName, cacheName), CacheResourceDefinition.Capability.CONFIGURATION.getServiceName(cacheAddress), Configuration.class).build(target).install();
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(containerName, cacheName), CacheResourceDefinition.Capability.CACHE.getServiceName(cacheAddress), Cache.class);
        ModelNodes.optionalString((ModelNode)CacheResourceDefinition.Attribute.JNDI_NAME.resolveModelAttribute((ExpressionResolver)context, model)).map(jndiName -> ContextNames.bindInfoFor((String)JndiNameFactory.parse((String)jndiName).getAbsoluteName())).ifPresent(aliasBinding -> bindingBuilder.alias(aliasBinding));
        bindingBuilder.build(target).install();
        for (CacheBuilderProvider cacheBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
            for (CapabilityServiceBuilder builder : cacheBuilderProvider.getBuilders(requirement -> CacheResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(cacheAddress), containerName, cacheName)) {
                builder.configure(context).build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) {
        PathAddress cacheAddress = context.getCurrentAddress();
        PathAddress containerAddress = cacheAddress.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        for (CacheBuilderProvider cacheBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
            for (ServiceNameProvider builder : cacheBuilderProvider.getBuilders(requirement -> CacheResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(cacheAddress), containerName, cacheName)) {
                context.removeService(builder.getServiceName());
            }
        }
        context.removeService(InfinispanBindingFactory.createCacheBinding(containerName, cacheName).getBinderServiceName());
        context.removeService(InfinispanBindingFactory.createCacheConfigurationBinding(containerName, cacheName).getBinderServiceName());
        context.removeService(new XAResourceRecoveryBuilder(cacheAddress).getServiceName());
        context.removeService(CacheComponent.MODULE.getServiceName(cacheAddress));
        EnumSet.allOf(CacheResourceDefinition.Capability.class).stream().map(capability -> capability.getServiceName(cacheAddress)).forEach(serviceName -> context.removeService(serviceName));
    }
}

