/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupsResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SegmentsAndVirtualNodeConverter;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.XMLAttribute;
import org.jboss.as.clustering.infinispan.subsystem.XMLElement;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class InfinispanSubsystemXMLReader
implements XMLElementReader<List<ModelNode>> {
    private final InfinispanSchema schema;

    InfinispanSubsystemXMLReader(InfinispanSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> result) throws XMLStreamException {
        LinkedHashMap<PathAddress, ModelNode> operations = new LinkedHashMap<PathAddress, ModelNode>();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanSubsystemResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, address, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.addAll(operations.values());
    }

    private void parseContainer(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{CacheContainerResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block27: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block27;
                }
                case DEFAULT_CACHE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE);
                    continue block27;
                }
                case JNDI_NAME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.Attribute.JNDI_NAME);
                    continue block27;
                }
                case LISTENER_EXECUTOR: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.ExecutorAttribute.LISTENER);
                    InfinispanLogger.ROOT_LOGGER.executorIgnored(CacheContainerResourceDefinition.ExecutorAttribute.LISTENER.getName());
                    continue block27;
                }
                case EVICTION_EXECUTOR: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.ExecutorAttribute.EVICTION);
                    InfinispanLogger.ROOT_LOGGER.executorIgnored(CacheContainerResourceDefinition.ExecutorAttribute.EVICTION.getName());
                    continue block27;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.ExecutorAttribute.REPLICATION_QUEUE);
                    InfinispanLogger.ROOT_LOGGER.executorIgnored(CacheContainerResourceDefinition.ExecutorAttribute.REPLICATION_QUEUE.getName());
                    continue block27;
                }
                case START: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1) && !this.schema.since(InfinispanSchema.VERSION_3_0)) {
                        InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                        continue block27;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case ALIASES: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        for (String value : reader.getListAttributeValue(i)) {
                            InfinispanSubsystemXMLReader.setAttribute(reader, value, operation, CacheContainerResourceDefinition.Attribute.ALIASES);
                        }
                        continue block27;
                    }
                }
                case MODULE: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_3)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.Attribute.MODULE);
                        continue block27;
                    }
                }
                case STATISTICS_ENABLED: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_5)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED);
                        continue block27;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!this.schema.since(InfinispanSchema.VERSION_1_5)) {
            operation.get(CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.getName()).set(true);
        }
        block29: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case ALIAS: {
                    if (InfinispanSchema.VERSION_1_0.since(this.schema)) {
                        InfinispanSubsystemXMLReader.readElement(reader, operation, CacheContainerResourceDefinition.Attribute.ALIASES);
                        continue block29;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case TRANSPORT: {
                    this.parseTransport(reader, address, operations);
                    continue block29;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, address, operations);
                    continue block29;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, address, operations);
                    continue block29;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, address, operations);
                    continue block29;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, address, operations);
                    continue block29;
                }
                case EXPIRATION_THREAD_POOL: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        this.parseScheduledThreadPool(ScheduledThreadPoolResourceDefinition.EXPIRATION, reader, address, operations);
                        continue block29;
                    }
                }
                case ASYNC_OPERATIONS_THREAD_POOL: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        this.parseThreadPool(ThreadPoolResourceDefinition.ASYNC_OPERATIONS, reader, address, operations);
                        continue block29;
                    }
                }
                case LISTENER_THREAD_POOL: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        this.parseThreadPool(ThreadPoolResourceDefinition.LISTENER, reader, address, operations);
                        continue block29;
                    }
                }
                case PERSISTENCE_THREAD_POOL: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        this.parseThreadPool(ThreadPoolResourceDefinition.PERSISTENCE, reader, address, operations);
                        continue block29;
                    }
                }
                case REMOTE_COMMAND_THREAD_POOL: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        this.parseThreadPool(ThreadPoolResourceDefinition.REMOTE_COMMAND, reader, address, operations);
                        continue block29;
                    }
                }
                case STATE_TRANSFER_THREAD_POOL: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        this.parseThreadPool(ThreadPoolResourceDefinition.STATE_TRANSFER, reader, address, operations);
                        continue block29;
                    }
                }
                case TRANSPORT_THREAD_POOL: {
                    if (!this.schema.since(InfinispanSchema.VERSION_4_0)) break;
                    this.parseThreadPool(ThreadPoolResourceDefinition.TRANSPORT, reader, address, operations);
                    continue block29;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = containerAddress.append(new PathElement[]{JGroupsTransportResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(containerAddress.append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}), operation);
        String stack = null;
        String cluster = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    if (this.schema.since(InfinispanSchema.VERSION_3_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    stack = value;
                    continue block10;
                }
                case EXECUTOR: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JGroupsTransportResourceDefinition.ExecutorAttribute.TRANSPORT);
                    InfinispanLogger.ROOT_LOGGER.executorIgnored(JGroupsTransportResourceDefinition.ExecutorAttribute.TRANSPORT.getName());
                    continue block10;
                }
                case LOCK_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JGroupsTransportResourceDefinition.Attribute.LOCK_TIMEOUT);
                    continue block10;
                }
                case SITE: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.topologyAttributeDeprecated(XMLAttribute.SITE.getLocalName());
                    continue block10;
                }
                case RACK: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.topologyAttributeDeprecated(XMLAttribute.RACK.getLocalName());
                    continue block10;
                }
                case MACHINE: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.topologyAttributeDeprecated(XMLAttribute.MACHINE.getLocalName());
                    continue block10;
                }
                case CLUSTER: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_2) && !this.schema.since(InfinispanSchema.VERSION_3_0)) {
                        cluster = value;
                        continue block10;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case CHANNEL: {
                    if (this.schema.since(InfinispanSchema.VERSION_3_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JGroupsTransportResourceDefinition.Attribute.CHANNEL);
                        continue block10;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!this.schema.since(InfinispanSchema.VERSION_3_0)) {
            String channel = cluster != null ? cluster : "ee-" + containerAddress.getLastElement().getValue();
            InfinispanSubsystemXMLReader.setAttribute(reader, channel, operation, JGroupsTransportResourceDefinition.Attribute.CHANNEL);
            PathAddress channelAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH, ChannelResourceDefinition.pathElement((String)channel)});
            ModelNode channelOperation = Util.createAddOperation((PathAddress)channelAddress);
            if (stack != null) {
                InfinispanSubsystemXMLReader.setAttribute(reader, stack, channelOperation, (Attribute)ChannelResourceDefinition.Attribute.STACK);
            }
            operations.put(channelAddress, channelOperation);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{LocalCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseCacheAttribute(reader, i, address, operations);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseCacheElement(reader, address, operations);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{ReplicatedCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseClusteredCacheAttribute(reader, i, address, operations);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseSharedStateCacheElement(reader, address, operations);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{DistributedCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.OWNERS);
                    continue block11;
                }
                case L1_LIFESPAN: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.L1_LIFESPAN);
                    continue block11;
                }
                case VIRTUAL_NODES: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_4)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    String virtualNodes = InfinispanSubsystemXMLReader.readAttribute(reader, i, DistributedCacheResourceDefinition.Attribute.SEGMENTS).asString();
                    String segments = SegmentsAndVirtualNodeConverter.virtualNodesToSegments(virtualNodes);
                    InfinispanSubsystemXMLReader.setAttribute(reader, segments, operation, DistributedCacheResourceDefinition.Attribute.SEGMENTS);
                    continue block11;
                }
                case SEGMENTS: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_4)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.SEGMENTS);
                        continue block11;
                    }
                }
                case CAPACITY_FACTOR: {
                    if (this.schema.since(InfinispanSchema.VERSION_3_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.CAPACITY_FACTOR);
                        continue block11;
                    }
                }
                case CONSISTENT_HASH_STRATEGY: {
                    if (this.schema.since(InfinispanSchema.VERSION_3_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, DistributedCacheResourceDefinition.Attribute.CONSISTENT_HASH_STRATEGY);
                        continue block11;
                    }
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, address, operations);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                this.parseSharedStateCacheElement(reader, address, operations);
                continue;
            }
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case REHASHING: {
                    this.parseStateTransfer(reader, address, operations);
                    continue block12;
                }
            }
            this.parseCacheElement(reader, address, operations);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = containerAddress.append(new PathElement[]{InvalidationCacheResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseClusteredCacheAttribute(reader, i, address, operations);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseCacheElement(reader, address, operations);
        }
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case NAME: {
                break;
            }
            case START: {
                if (this.schema.since(InfinispanSchema.VERSION_3_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            case BATCHING: {
                if (this.schema.since(InfinispanSchema.VERSION_3_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                PathAddress transactionAddress = address.append(new PathElement[]{TransactionResourceDefinition.PATH});
                ModelNode transactionOperation = Util.createAddOperation((PathAddress)transactionAddress);
                transactionOperation.get(TransactionResourceDefinition.Attribute.MODE.getName()).set(new ModelNode(TransactionMode.BATCH.name()));
                operations.put(transactionAddress, transactionOperation);
                break;
            }
            case INDEXING: {
                if (this.schema.since(InfinispanSchema.VERSION_1_4)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, CacheResourceDefinition.DeprecatedAttribute.INDEXING);
                break;
            }
            case JNDI_NAME: {
                if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, CacheResourceDefinition.Attribute.JNDI_NAME);
                    break;
                }
            }
            case MODULE: {
                if (this.schema.since(InfinispanSchema.VERSION_1_3)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, CacheResourceDefinition.Attribute.MODULE);
                    break;
                }
            }
            case STATISTICS_ENABLED: {
                if (this.schema.since(InfinispanSchema.VERSION_1_5)) {
                    InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, CacheResourceDefinition.Attribute.STATISTICS_ENABLED);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
        if (!this.schema.since(InfinispanSchema.VERSION_1_5)) {
            operation.get(CacheResourceDefinition.Attribute.STATISTICS_ENABLED.getName()).set(true);
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case MODE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, ClusteredCacheResourceDefinition.Attribute.MODE);
                break;
            }
            case QUEUE_SIZE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, ClusteredCacheResourceDefinition.DeprecatedAttribute.QUEUE_SIZE);
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, ClusteredCacheResourceDefinition.DeprecatedAttribute.QUEUE_FLUSH_INTERVAL);
                break;
            }
            case REMOTE_TIMEOUT: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, ClusteredCacheResourceDefinition.Attribute.REMOTE_TIMEOUT);
                break;
            }
            case ASYNC_MARSHALLING: {
                if (!this.schema.since(InfinispanSchema.VERSION_1_2) && this.schema.since(InfinispanSchema.VERSION_4_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, address, operations);
            }
        }
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        XMLElement element = XMLElement.forName(reader.getLocalName());
        switch (element) {
            case EVICTION: {
                this.parseEviction(reader, cacheAddress, operations);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cacheAddress, operations);
                break;
            }
            case LOCKING: {
                this.parseLocking(reader, cacheAddress, operations);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cacheAddress, operations);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cacheAddress, operations);
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cacheAddress, operations);
                break;
            }
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, cacheAddress, operations);
                break;
            }
            case JDBC_STORE: {
                if (this.schema.since(InfinispanSchema.VERSION_1_2)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.parseJDBCStore(reader, cacheAddress, operations);
                break;
            }
            case STRING_KEYED_JDBC_STORE: {
                if (this.schema.since(InfinispanSchema.VERSION_1_2)) {
                    this.parseStringKeyedJDBCStore(reader, cacheAddress, operations);
                    break;
                }
            }
            case BINARY_KEYED_JDBC_STORE: {
                if (this.schema.since(InfinispanSchema.VERSION_1_2)) {
                    this.parseBinaryKeyedJDBCStore(reader, cacheAddress, operations);
                    break;
                }
            }
            case MIXED_KEYED_JDBC_STORE: {
                if (this.schema.since(InfinispanSchema.VERSION_1_2)) {
                    this.parseMixedKeyedJDBCStore(reader, cacheAddress, operations);
                    break;
                }
            }
            case INDEXING: {
                if (this.schema.since(InfinispanSchema.VERSION_1_4) && !this.schema.since(InfinispanSchema.VERSION_4_0)) {
                    this.parseIndexing(reader, cacheAddress, operations);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseSharedStateCacheElement(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        XMLElement element = XMLElement.forName(reader.getLocalName());
        switch (element) {
            case STATE_TRANSFER: {
                this.parseStateTransfer(reader, address, operations);
                break;
            }
            case BACKUPS: {
                if (this.schema.since(InfinispanSchema.VERSION_2_0)) {
                    this.parseBackups(reader, address, operations);
                    break;
                }
            }
            case BACKUP_FOR: {
                if (this.schema.since(InfinispanSchema.VERSION_2_0)) {
                    this.parseBackupFor(reader, address, operations);
                    break;
                }
            }
            case PARTITION_HANDLING: {
                if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                    this.parsePartitionHandling(reader, address, operations);
                    break;
                }
            }
            default: {
                this.parseCacheElement(reader, address, operations);
            }
        }
    }

    private void parsePartitionHandling(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{PartitionHandlingResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, PartitionHandlingResourceDefinition.Attribute.ENABLED);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{StateTransferResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                case TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StateTransferResourceDefinition.Attribute.TIMEOUT);
                    continue block6;
                }
                case FLUSH_TIMEOUT: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                case CHUNK_SIZE: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StateTransferResourceDefinition.Attribute.CHUNK_SIZE);
                        continue block6;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseBackups(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{BackupsResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, address, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackup(XMLExtendedStreamReader reader, PathAddress backupsAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String site = InfinispanSubsystemXMLReader.require(reader, XMLAttribute.SITE);
        PathAddress address = backupsAddress.append(new PathElement[]{BackupResourceDefinition.pathElement(site)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    continue block14;
                }
                case STRATEGY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.Attribute.STRATEGY);
                    continue block14;
                }
                case BACKUP_FAILURE_POLICY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.Attribute.FAILURE_POLICY);
                    continue block14;
                }
                case TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.Attribute.TIMEOUT);
                    continue block14;
                }
                case ENABLED: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.Attribute.ENABLED);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case TAKE_OFFLINE_AFTER_FAILURES: {
                                InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.TakeOfflineAttribute.AFTER_FAILURES);
                                continue block16;
                            }
                            case TAKE_OFFLINE_MIN_WAIT: {
                                InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupResourceDefinition.TakeOfflineAttribute.MIN_WAIT);
                                continue block16;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{BackupForResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CACHE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupForResourceDefinition.Attribute.CACHE);
                    continue block4;
                }
                case REMOTE_SITE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BackupForResourceDefinition.Attribute.SITE);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLocking(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{LockingResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.ISOLATION);
                    continue block6;
                }
                case STRIPING: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.STRIPING);
                    continue block6;
                }
                case ACQUIRE_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.ACQUIRE_TIMEOUT);
                    continue block6;
                }
                case CONCURRENCY_LEVEL: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, LockingResourceDefinition.Attribute.CONCURRENCY);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{TransactionResourceDefinition.PATH});
        ModelNode operation = operations.get(address);
        if (operation == null) {
            operation = Util.createAddOperation((PathAddress)address);
            operations.put(address, operation);
        }
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, TransactionResourceDefinition.Attribute.STOP_TIMEOUT);
                    continue block6;
                }
                case MODE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, TransactionResourceDefinition.Attribute.MODE);
                    continue block6;
                }
                case LOCKING: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, TransactionResourceDefinition.Attribute.LOCKING);
                    continue block6;
                }
                case EAGER_LOCKING: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseEviction(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{EvictionResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, EvictionResourceDefinition.Attribute.STRATEGY);
                    continue block5;
                }
                case MAX_ENTRIES: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, EvictionResourceDefinition.Attribute.MAX_ENTRIES);
                    continue block5;
                }
                case INTERVAL: {
                    if (this.schema.since(InfinispanSchema.VERSION_1_1)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{ExpirationResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ExpirationResourceDefinition.Attribute.MAX_IDLE);
                    continue block5;
                }
                case LIFESPAN: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ExpirationResourceDefinition.Attribute.LIFESPAN);
                    continue block5;
                }
                case INTERVAL: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, ExpirationResourceDefinition.Attribute.INTERVAL);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(cacheAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INDEX: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CacheResourceDefinition.DeprecatedAttribute.INDEXING);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)XMLAttribute.NAME.getLocalName());
                    InfinispanSubsystemXMLReader.readAttribute(reader, 0, operation, CacheResourceDefinition.DeprecatedAttribute.INDEXING_PROPERTIES);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{CustomStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, CustomStoreResourceDefinition.Attribute.CLASS);
                    continue block3;
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        if (!operation.hasDefined(CustomStoreResourceDefinition.Attribute.CLASS.getName())) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(XMLAttribute.CLASS));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseFileStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{FileStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, FileStoreResourceDefinition.Attribute.RELATIVE_TO);
                    continue block4;
                }
                case PATH: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, FileStoreResourceDefinition.Attribute.RELATIVE_PATH);
                    continue block4;
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{RemoteStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.CACHE);
                    continue block12;
                }
                case SOCKET_TIMEOUT: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.SOCKET_TIMEOUT);
                    continue block12;
                }
                case TCP_NO_DELAY: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.TCP_NO_DELAY);
                    continue block12;
                }
                case REMOTE_SERVERS: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        for (String value : reader.getListAttributeValue(i)) {
                            InfinispanSubsystemXMLReader.setAttribute(reader, value, operation, RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS);
                        }
                        continue block12;
                    }
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case OUTBOUND_SOCKET_BINDING: {
                                InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS);
                                continue block15;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block14;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
        if (!operation.hasDefined(RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS.getName())) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(XMLAttribute.REMOTE_SERVERS.getLocalName()));
        }
    }

    private void parseJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = null;
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation();
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operation);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case ENTRY_TABLE: {
                    if (address != null) {
                        this.removeStoreOperations(address, operations);
                    }
                    address = cacheAddress.append(new PathElement[]{address == null ? StringKeyedJDBCStoreResourceDefinition.PATH : MixedKeyedJDBCStoreResourceDefinition.PATH});
                    Operations.setPathAddress((ModelNode)operation, (PathAddress)address);
                    ModelNode binaryTableOperation = operations.get(operationKey.append(new PathElement[]{BinaryTableResourceDefinition.PATH}));
                    if (binaryTableOperation != null) {
                        Operations.setPathAddress((ModelNode)binaryTableOperation, (PathAddress)address.append(new PathElement[]{BinaryTableResourceDefinition.PATH}));
                    }
                    this.parseJDBCStoreStringTable(reader, address, operations);
                    continue block4;
                }
                case BUCKET_TABLE: {
                    if (address != null) {
                        this.removeStoreOperations(address, operations);
                    }
                    address = cacheAddress.append(new PathElement[]{address == null ? BinaryKeyedJDBCStoreResourceDefinition.PATH : MixedKeyedJDBCStoreResourceDefinition.PATH});
                    Operations.setPathAddress((ModelNode)operation, (PathAddress)address);
                    ModelNode stringTableOperation = operations.get(operationKey.append(new PathElement[]{StringTableResourceDefinition.PATH}));
                    if (stringTableOperation != null) {
                        Operations.setPathAddress((ModelNode)stringTableOperation, (PathAddress)address.append(new PathElement[]{StringTableResourceDefinition.PATH}));
                    }
                    this.parseJDBCStoreBinaryTable(reader, address, operations);
                    continue block4;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseBinaryKeyedJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{BinaryKeyedJDBCStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operation);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreBinaryTable(reader, address, operations);
                    continue block3;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseStringKeyedJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{StringKeyedJDBCStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operation);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreStringTable(reader, address, operations);
                    continue block3;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseMixedKeyedJDBCStore(XMLExtendedStreamReader reader, PathAddress cacheAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = cacheAddress.append(new PathElement[]{MixedKeyedJDBCStoreResourceDefinition.PATH});
        PathAddress operationKey = cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH});
        if (operations.containsKey(operationKey)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(operationKey, operation);
        this.parseJDBCStoreAttributes(reader, operation);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreBinaryTable(reader, address, operations);
                    continue block4;
                }
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreStringTable(reader, address, operations);
                    continue block4;
                }
            }
            this.parseStoreElement(reader, address, operations);
        }
    }

    private void parseJDBCStoreAttributes(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        Enum requiredAttribute;
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JDBCStoreResourceDefinition.DeprecatedAttribute.DATASOURCE);
                    continue block5;
                }
                case DIALECT: {
                    if (this.schema.since(InfinispanSchema.VERSION_2_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JDBCStoreResourceDefinition.Attribute.DIALECT);
                        continue block5;
                    }
                }
                case DATA_SOURCE: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, JDBCStoreResourceDefinition.Attribute.DATA_SOURCE);
                        continue block5;
                    }
                }
                default: {
                    this.parseStoreAttribute(reader, i, operation);
                }
            }
        }
        Enum enum_ = requiredAttribute = this.schema.since(InfinispanSchema.VERSION_4_0) ? JDBCStoreResourceDefinition.Attribute.DATA_SOURCE : JDBCStoreResourceDefinition.DeprecatedAttribute.DATASOURCE;
        if (!operation.hasDefined(requiredAttribute.getName())) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{requiredAttribute.getName()});
        }
    }

    private void parseJDBCStoreBinaryTable(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = storeAddress.append(new PathElement[]{BinaryTableResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(storeAddress.getParent().append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{BinaryTableResourceDefinition.PATH}), operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, BinaryTableResourceDefinition.Attribute.PREFIX);
                    continue block3;
                }
                default: {
                    this.parseJDBCStoreTableAttribute(reader, i, operation);
                }
            }
        }
        this.parseJDBCStoreTableElements(reader, operation);
    }

    private void parseJDBCStoreStringTable(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = storeAddress.append(new PathElement[]{StringTableResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(storeAddress.getParent().append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{StringTableResourceDefinition.PATH}), operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StringTableResourceDefinition.Attribute.PREFIX);
                    continue block3;
                }
                default: {
                    this.parseJDBCStoreTableAttribute(reader, i, operation);
                }
            }
        }
        this.parseJDBCStoreTableElements(reader, operation);
    }

    private void parseJDBCStoreTableAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case FETCH_SIZE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, TableResourceDefinition.Attribute.FETCH_SIZE);
                break;
            }
            case BATCH_SIZE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, TableResourceDefinition.Attribute.BATCH_SIZE);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseJDBCStoreTableElements(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    this.parseJDBCStoreColumn(reader, TableResourceDefinition.ColumnAttribute.ID, operation.get(TableResourceDefinition.ColumnAttribute.ID.getName()).setEmptyObject());
                    continue block5;
                }
                case DATA_COLUMN: {
                    this.parseJDBCStoreColumn(reader, TableResourceDefinition.ColumnAttribute.DATA, operation.get(TableResourceDefinition.ColumnAttribute.DATA.getName()).setEmptyObject());
                    continue block5;
                }
                case TIMESTAMP_COLUMN: {
                    this.parseJDBCStoreColumn(reader, TableResourceDefinition.ColumnAttribute.TIMESTAMP, operation.get(TableResourceDefinition.ColumnAttribute.TIMESTAMP.getName()).setEmptyObject());
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJDBCStoreColumn(XMLExtendedStreamReader reader, TableResourceDefinition.ColumnAttribute columnAttribute, ModelNode column) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, column, columnAttribute.getColumnName());
                    continue block4;
                }
                case TYPE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, column, columnAttribute.getColumnType());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void removeStoreOperations(PathAddress storeAddress, Map<PathAddress, ModelNode> operations) {
        operations.remove(storeAddress.append(new PathElement[]{StoreWriteResourceDefinition.WILDCARD_PATH}));
    }

    private void parseStoreAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SHARED: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.SHARED);
                break;
            }
            case PRELOAD: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.PRELOAD);
                break;
            }
            case PASSIVATION: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.PASSIVATION);
                break;
            }
            case FETCH_STATE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.FETCH_STATE);
                break;
            }
            case PURGE: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.PURGE);
                break;
            }
            case SINGLETON: {
                InfinispanSubsystemXMLReader.readAttribute(reader, index, operation, StoreResourceDefinition.Attribute.SINGLETON);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseStoreElement(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(storeAddress.getParent().append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH}));
        XMLElement element = XMLElement.forName(reader.getLocalName());
        switch (element) {
            case PROPERTY: {
                ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)XMLAttribute.NAME.getLocalName());
                InfinispanSubsystemXMLReader.readAttribute(reader, 0, operation, StoreResourceDefinition.Attribute.PROPERTIES);
                break;
            }
            case WRITE_BEHIND: {
                if (this.schema.since(InfinispanSchema.VERSION_1_2)) {
                    this.parseStoreWriteBehind(reader, storeAddress, operations);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseStoreWriteBehind(XMLExtendedStreamReader reader, PathAddress storeAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = storeAddress.append(new PathElement[]{StoreWriteBehindResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(storeAddress.append(new PathElement[]{StoreWriteResourceDefinition.WILDCARD_PATH}), operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StoreWriteBehindResourceDefinition.Attribute.MODIFICATION_QUEUE_SIZE);
                    continue block6;
                }
                case SHUTDOWN_TIMEOUT: {
                    if (this.schema.since(InfinispanSchema.VERSION_4_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.attributeDeprecated(attribute.getLocalName(), reader.getLocalName());
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, StoreWriteBehindResourceDefinition.Attribute.THREAD_POOL_SIZE);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static String require(XMLExtendedStreamReader reader, XMLAttribute attribute) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getLocalName());
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
        }
        return value;
    }

    private static ModelNode readAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute) throws XMLStreamException {
        return ((AttributeDefinition)attribute.getDefinition()).getParser().parse((AttributeDefinition)attribute.getDefinition(), reader.getAttributeValue(index), (XMLStreamReader)reader);
    }

    private static void readAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation, Attribute attribute) throws XMLStreamException {
        InfinispanSubsystemXMLReader.setAttribute(reader, reader.getAttributeValue(index), operation, attribute);
    }

    private static void setAttribute(XMLExtendedStreamReader reader, String value, ModelNode operation, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getParser().parseAndSetParameter((AttributeDefinition)attribute.getDefinition(), value, operation, (XMLStreamReader)reader);
    }

    private static void readElement(XMLExtendedStreamReader reader, ModelNode operation, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getParser().parseAndSetParameter((AttributeDefinition)attribute.getDefinition(), reader.getElementText(), operation, (XMLStreamReader)reader);
    }

    private void parseThreadPool(ThreadPoolResourceDefinition pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{pool.getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MIN_THREADS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMinThreads());
                    continue block6;
                }
                case MAX_THREADS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMaxThreads());
                    continue block6;
                }
                case QUEUE_LENGTH: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getQueueLength());
                    continue block6;
                }
                case KEEPALIVE_TIME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getKeepAliveTime());
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseScheduledThreadPool(ScheduledThreadPoolResourceDefinition pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{pool.getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_THREADS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMaxThreads());
                    continue block4;
                }
                case KEEPALIVE_TIME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getKeepAliveTime());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

