/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.health.HealthHttpHandlerService;
import org.wildfly.extension.microprofile.health.HealthMonitorService;
import org.wildfly.extension.microprofile.health.MicroProfileHealthLogger;
import org.wildfly.extension.microprofile.health.SubsystemDefinition;
import org.wildfly.extension.microprofile.health.deployment.DependencyProcessor;
import org.wildfly.extension.microprofile.health.deployment.SubsystemDeploymentProcessor;

class SubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final SubsystemAdd INSTANCE = new SubsystemAdd();

    private SubsystemAdd() {
        super(SubsystemDefinition.ATTRIBUTES);
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        MicroProfileHealthLogger.ROOT_LOGGER.activatingSubsystem();
        HealthMonitorService.install(context);
        String serverName = SubsystemDefinition.HTTP_SERVER.resolveModelAttribute(context, model).asString();
        String vHostName = SubsystemDefinition.HTTP_VIRTUAL_HOST.resolveModelAttribute(context, model).asString();
        ModelNode path = SubsystemDefinition.HTTP_PATH.resolveModelAttribute(context, model);
        if (path.isDefined()) {
            HealthHttpHandlerService.install(context, serverName, vHostName, path.asString());
        }
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("microprofile-health", DependencyProcessor.PHASE, 16384, (DeploymentUnitProcessor)new DependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-health", SubsystemDeploymentProcessor.PHASE, 16384, (DeploymentUnitProcessor)new SubsystemDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

