/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.Unmanaged;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.wildfly.extension.microprofile.health.HealthMonitor;
import org.wildfly.extension.microprofile.health.MicroProfileHealthLogger;

public class CDIExtension
implements Extension {
    private final HealthMonitor healthMonitor;
    private List<AnnotatedType<? extends HealthCheck>> delegates = new ArrayList<AnnotatedType<? extends HealthCheck>>();
    private Collection<HealthCheck> healthChecks = new ArrayList<HealthCheck>();
    private Collection<Unmanaged.UnmanagedInstance<HealthCheck>> healthCheckInstances = new ArrayList<Unmanaged.UnmanagedInstance<HealthCheck>>();

    public CDIExtension(HealthMonitor healthMonitor) {
        this.healthMonitor = healthMonitor;
    }

    public void observeResources(@Observes @WithAnnotations(value={Health.class}) ProcessAnnotatedType<? extends HealthCheck> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        MicroProfileHealthLogger.ROOT_LOGGER.debugf("Discovered health check procedure %s", javaClass);
        this.delegates.add((AnnotatedType<? extends HealthCheck>)annotatedType);
    }

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        for (AnnotatedType<? extends HealthCheck> delegate : this.delegates) {
            try {
                Unmanaged unmanagedHealthCheck = new Unmanaged(bm, delegate.getJavaClass());
                Unmanaged.UnmanagedInstance healthCheckInstance = unmanagedHealthCheck.newInstance();
                HealthCheck healthCheck = (HealthCheck)healthCheckInstance.produce().inject().postConstruct().get();
                this.healthChecks.add(healthCheck);
                this.healthCheckInstances.add((Unmanaged.UnmanagedInstance<HealthCheck>)healthCheckInstance);
                this.healthMonitor.addHealthCheck(healthCheck);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register health bean", e);
            }
        }
    }

    public void close(@Observes BeforeShutdown bs) {
        this.healthChecks.forEach(healthCheck -> this.healthMonitor.removeHealthCheck((HealthCheck)healthCheck));
        this.healthChecks.clear();
        this.healthCheckInstances.forEach(instance -> instance.preDestroy().dispose());
        this.healthCheckInstances.clear();
    }
}

