/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;

public class JMSManagementHelper {
    private static org.apache.activemq.artemis.api.core.Message getCoreMessage(Message jmsMessage) {
        if (!(jmsMessage instanceof ActiveMQMessage)) {
            throw new IllegalArgumentException("Cannot send a foreign message as a management message " + jmsMessage.getClass().getName());
        }
        return ((ActiveMQMessage)jmsMessage).getCoreMessage();
    }

    public static void putAttribute(Message message, String resourceName, String attribute) throws JMSException {
        ManagementHelper.putAttribute((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)attribute);
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)operationName);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    private static JMSException convertFromException(Exception e) {
        JMSException jmse = new JMSException(e.getMessage());
        jmse.initCause((Throwable)e);
        return jmse;
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName, Object ... parameters) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)operationName, (Object[])parameters);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    public static boolean isOperationResult(Message message) throws JMSException {
        return ManagementHelper.isOperationResult((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean isAttributesResult(Message message) throws JMSException {
        return ManagementHelper.isAttributesResult((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean hasOperationSucceeded(Message message) throws JMSException {
        return ManagementHelper.hasOperationSucceeded((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static Object[] getResults(Message message) throws Exception {
        return ManagementHelper.getResults((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static Object getResult(Message message) throws Exception {
        return JMSManagementHelper.getResult(message, null);
    }

    public static Object getResult(Message message, Class desiredType) throws Exception {
        return ManagementHelper.getResult((org.apache.activemq.artemis.api.core.Message)JMSManagementHelper.getCoreMessage(message), (Class)desiredType);
    }

    private JMSManagementHelper() {
    }
}

