/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.jbossjpaparser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.jpa.config.ExtendedPersistenceInheritance;
import org.jboss.as.jpa.config.JPADeploymentSettings;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JBossJPAParser {
    public static final String NAMESPACE_1_0 = "http://www.jboss.com/xml/ns/javaee";
    private static final JBossJPAParser INSTANCE = new JBossJPAParser();
    private static final String INHERITANCE_CONSTANT = "inheritance";

    public static JPADeploymentSettings parser(XMLExtendedStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        JPADeploymentSettings result = new JPADeploymentSettings();
        INSTANCE.readElement(reader, result, propertyReplacer);
        return result;
    }

    private JBossJPAParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, JPADeploymentSettings result, PropertyReplacer propertyReplacer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw JBossJPAParser.unexpectedContent((XMLStreamReader)reader);
        }
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EXTENDED_PERSISTENCE: {
                            String value = JBossJPAParser.getAttributeValue((XMLStreamReader)reader, null, INHERITANCE_CONSTANT, propertyReplacer);
                            if (value == null || value.isEmpty()) {
                                result.setExtendedPersistenceInheritanceType(ExtendedPersistenceInheritance.SHALLOW);
                                continue block7;
                            }
                            result.setExtendedPersistenceInheritanceType(ExtendedPersistenceInheritance.valueOf(value));
                            continue block7;
                        }
                    }
                    throw JBossJPAParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw JBossJPAParser.unexpectedContent((XMLStreamReader)reader);
        }
        throw JBossJPAParser.endOfDocument(reader.getLocation());
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        return ServerLogger.ROOT_LOGGER.unexpectedContent(kind, reader.hasName() ? reader.getName() : null, reader.hasText() ? reader.getText() : null, reader.getLocation());
    }

    private static String getAttributeValue(XMLStreamReader reader, String namespaceURI, String localName, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return propertyReplacer.replaceProperties(reader.getAttributeValue(namespaceURI, localName));
    }

    private static XMLStreamException endOfDocument(Location location) {
        return ServerLogger.ROOT_LOGGER.unexpectedEndOfDocument(location);
    }

    static enum Attribute {
        INHERITANCE,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName(JBossJPAParser.INHERITANCE_CONSTANT), INHERITANCE);
            attributes = attributesMap;
        }
    }

    static enum Version {
        JBOSS_JPA_1_0,
        UNKNOWN;

    }

    static enum Element {
        JBOSS_JPA_DESCRIPTOR,
        EXTENDED_PERSISTENCE,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(JBossJPAParser.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(JBossJPAParser.NAMESPACE_1_0, "jboss-jpa"), JBOSS_JPA_DESCRIPTOR);
            elementsMap.put(new QName(JBossJPAParser.NAMESPACE_1_0, "extended-persistence"), EXTENDED_PERSISTENCE);
            elements = elementsMap;
        }
    }
}

