/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;
import org.wildfly.clustering.marshalling.Externalizer;

public enum IdentifierExternalizer implements Externalizer<String>
{
    UTF8{

        public void writeObject(ObjectOutput output, String id) throws IOException {
            output.writeUTF(id);
        }

        public String readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return input.readUTF();
        }
    }
    ,
    BASE64{

        public void writeObject(ObjectOutput output, String id) throws IOException {
            byte[] bytes = Base64.getUrlDecoder().decode(id);
            output.writeByte(bytes.length);
            output.write(bytes);
        }

        public String readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] decoded = new byte[input.readUnsignedByte()];
            input.read(decoded);
            return Base64.getUrlEncoder().encodeToString(decoded);
        }
    }
    ,
    HEX{

        public void writeObject(ObjectOutput output, String id) throws IOException {
            byte[] bytes = DatatypeConverter.parseHexBinary((String)id);
            output.writeByte(bytes.length);
            output.write(bytes);
        }

        public String readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] decoded = new byte[input.readUnsignedByte()];
            input.read(decoded);
            return DatatypeConverter.printHexBinary((byte[])decoded);
        }
    };


    public Class<String> getTargetClass() {
        return String.class;
    }
}

