/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;
import org.wildfly.clustering.server.group.LocalNodeFactory;

public class LocalNodeFactoryBuilder
implements CapabilityServiceBuilder<JGroupsNodeFactory> {
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final ServiceName name;
    private final String group;

    public LocalNodeFactoryBuilder(ServiceName name, String group) {
        this.name = name;
        this.group = group;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public ServiceBuilder<JGroupsNodeFactory> build(ServiceTarget target) {
        Value value = () -> new LocalNodeFactory(this.group, ((ServerEnvironment)this.environment.getValue()).getNodeName());
        return target.addService(this.name, (Service)new ValueService(value)).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

