/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class FunctionalValueService<T, V>
implements Service<V> {
    private static final Logger LOGGER = Logger.getLogger(FunctionalValueService.class);
    private final Function<T, V> mapper;
    private final Function<StartContext, T> factory;
    private final BiConsumer<StopContext, T> destroyer;
    private volatile T value;

    public FunctionalValueService(Function<T, V> mapper, Function<StartContext, T> factory, BiConsumer<StopContext, T> destroyer) {
        this.mapper = mapper;
        this.factory = factory;
        this.destroyer = destroyer;
    }

    public V getValue() {
        return this.mapper.apply(this.value);
    }

    public void start(StartContext context) throws StartException {
        try {
            this.value = this.factory.apply(context);
        }
        catch (Throwable e) {
            throw new StartException(e);
        }
    }

    public void stop(StopContext context) {
        if (this.destroyer != null) {
            try {
                this.destroyer.accept(context, (StopContext)this.value);
            }
            catch (Throwable e) {
                LOGGER.warn((Object)e.getLocalizedMessage(), e);
            }
            finally {
                this.value = null;
            }
        }
    }
}

