/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashSet;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class PropertySQLProviderFactory
implements SQLProvider.Factory {
    private static final String ORACLE = "oracle";
    String database;
    private volatile Properties sql;
    private final HashSet<String> databaseDialects = new HashSet();

    public PropertySQLProviderFactory(String database) throws IOException {
        this.database = database;
        try (InputStream stream = PropertySQLProvider.class.getClassLoader().getResourceAsStream("journal-sql.properties");){
            this.sql = new Properties();
            this.sql.load(stream);
            this.extractDialects();
        }
    }

    public SQLProvider create(String tableName) {
        String name = ORACLE.equals(this.database) ? tableName.toUpperCase() : tableName;
        return new PropertySQLProvider(name);
    }

    private void extractDialects() {
        for (Object prop : this.sql.keySet()) {
            int dot = ((String)prop).indexOf(46);
            if (dot <= 0) continue;
            this.databaseDialects.add(((String)prop).substring(dot + 1));
        }
    }

    public void investigateDialect(DataSource dataSource) {
        if (this.database != null) {
            return;
        }
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String dbProduct = metaData.getDatabaseProductName();
            this.database = this.identifyDialect(dbProduct);
            if (this.database == null) {
                MessagingLogger.ROOT_LOGGER.debug("Attempting to guess on driver name.");
                this.database = this.identifyDialect(metaData.getDriverName());
            }
            if (dataSource == null) {
                MessagingLogger.ROOT_LOGGER.jdbcDatabaseDialectDetectionFailed(this.databaseDialects.toString());
            } else {
                MessagingLogger.ROOT_LOGGER.debugf("Detect database dialect as '%s'.  If this is incorrect, please specify the correct dialect using the 'database' attribute in your configuration.  Supported database dialect strings are %s", this.database, this.databaseDialects);
            }
        }
        catch (Exception e) {
            MessagingLogger.ROOT_LOGGER.debug("Unable to read JDBC metadata.", e);
        }
    }

    private String identifyDialect(String name) {
        String unified = null;
        if (name != null) {
            if (name.toLowerCase().contains("postgres")) {
                unified = "postgresql";
            } else if (name.toLowerCase().contains("mysql")) {
                unified = "mysql";
            } else if (name.toLowerCase().contains("db2")) {
                unified = "db2";
            } else if (name.toLowerCase().contains("derby")) {
                unified = "derby";
            } else if (name.toLowerCase().contains("hsql") || name.toLowerCase().contains("hypersonic")) {
                unified = "hsql";
            } else if (name.toLowerCase().contains("h2")) {
                unified = "h2";
            } else if (name.toLowerCase().contains(ORACLE)) {
                unified = ORACLE;
            } else if (name.toLowerCase().contains("microsoft")) {
                unified = "mssql";
            } else if (name.toLowerCase().contains("jconnect")) {
                unified = "sybase";
            }
        }
        MessagingLogger.ROOT_LOGGER.debugf("Check dialect for '%s', result is '%s'", name, unified);
        return unified;
    }

    private class PropertySQLProvider
    implements SQLProvider {
        private final String tableName;

        public PropertySQLProvider(String tableName) {
            this.tableName = tableName;
        }

        public long getMaxBlobSize() {
            return Long.valueOf(this.sql("max-blob-size"));
        }

        public String[] getCreateJournalTableSQL() {
            return new String[]{String.format(this.sql("create-journal-table"), this.tableName), String.format(this.sql("create-journal-index"), this.tableName)};
        }

        public String getInsertJournalRecordsSQL() {
            return String.format(this.sql("insert-journal-record"), this.tableName);
        }

        public String getSelectJournalRecordsSQL() {
            return String.format(this.sql("select-journal-record"), this.tableName);
        }

        public String getDeleteJournalRecordsSQL() {
            return String.format(this.sql("delete-journal-record"), this.tableName);
        }

        public String getDeleteJournalTxRecordsSQL() {
            return String.format(this.sql("delete-journal-tx-record"), this.tableName);
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getCreateFileTableSQL() {
            return String.format(this.sql("create-file-table"), this.tableName);
        }

        public String getInsertFileSQL() {
            return String.format(this.sql("insert-file"), this.tableName);
        }

        public String getSelectFileNamesByExtensionSQL() {
            return String.format(this.sql("select-filenames-by-extension"), this.tableName);
        }

        public String getSelectFileByFileName() {
            return String.format(this.sql("select-file-by-filename"), this.tableName);
        }

        public String getAppendToLargeObjectSQL() {
            return String.format(this.sql("append-to-file"), this.tableName);
        }

        public String getReadLargeObjectSQL() {
            return String.format(this.sql("read-large-object"), this.tableName);
        }

        public String getDeleteFileSQL() {
            return String.format(this.sql("delete-file"), this.tableName);
        }

        public String getUpdateFileNameByIdSQL() {
            return String.format(this.sql("update-filename-by-id"), this.tableName);
        }

        public String getCopyFileRecordByIdSQL() {
            return String.format(this.sql("copy-file-record-by-id"), this.tableName);
        }

        public String getDropFileTableSQL() {
            return String.format(this.sql("drop-table"), this.tableName);
        }

        public String getCloneFileRecordByIdSQL() {
            return String.format(this.sql("clone-file-record"), this.tableName);
        }

        public String getCountJournalRecordsSQL() {
            return String.format(this.sql("count-journal-record"), this.tableName);
        }

        public boolean closeConnectionOnShutdown() {
            return Boolean.valueOf(this.sql("close-connection-on-shutdown"));
        }

        private String sql(String key) {
            String result;
            if (PropertySQLProviderFactory.this.database != null && (result = PropertySQLProviderFactory.this.sql.getProperty(key + "." + PropertySQLProviderFactory.this.database)) != null) {
                return result;
            }
            return PropertySQLProviderFactory.this.sql.getProperty(key);
        }
    }
}

