/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.GlobalSecurityManager;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.security.impl.CachePrincipalPair;
import org.infinispan.security.impl.SubjectACL;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private AuthorizationConfiguration configuration;
    private AuthorizationHelper authzHelper;

    @Inject
    public void init(Cache<?, ?> cache, GlobalConfiguration globalConfiguration, Configuration configuration, GlobalSecurityManager globalSecurityManager, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration.security().authorization();
        Cache<?, ?> globalACLCache = globalSecurityManager.globalACLCache();
        this.authzHelper = new AuthorizationHelper(globalConfiguration.security(), AuditContext.CACHE, cache.getName(), (ConcurrentMap<CachePrincipalPair, SubjectACL>)((Object)globalACLCache));
        if (globalACLCache != null) {
            cacheManager.addCacheDependency(cache.getName(), globalACLCache.getName());
        }
    }

    @Override
    public void checkPermission(AuthorizationPermission perm) {
        this.authzHelper.checkPermission(this.configuration, perm, null);
    }

    @Override
    public void checkPermission(AuthorizationPermission perm, String role) {
        this.authzHelper.checkPermission(this.configuration, perm, role);
    }
}

