/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers.oracle;

import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class Oracle12CSQLProvider
extends GenericSQLProvider {
    private final String createFileTableSQL;
    private final String createJournalTableSQL;
    private static final long MAX_BLOB_SIZE = 0x100000000L;

    protected Oracle12CSQLProvider(String tableName) {
        super(tableName);
        this.createFileTableSQL = "CREATE TABLE " + this.tableName + " (ID NUMBER(19) GENERATED BY DEFAULT ON NULL AS IDENTITY, FILENAME VARCHAR(255), EXTENSION VARCHAR(10), DATA BLOB, PRIMARY KEY(ID))";
        this.createJournalTableSQL = "CREATE TABLE " + this.tableName + " (id NUMBER(19) GENERATED BY DEFAULT ON NULL AS IDENTITY,recordType NUMBER(5),compactCount NUMBER(5),txId NUMBER(19),userRecordType NUMBER(5),variableSize NUMBER(10),record BLOB,txDataSize NUMBER(10),txData BLOB,txCheckNoRecords NUMBER(10),seq NUMBER(19))";
    }

    @Override
    public long getMaxBlobSize() {
        return 0x100000000L;
    }

    @Override
    public String getCreateFileTableSQL() {
        return this.createFileTableSQL;
    }

    @Override
    public String[] getCreateJournalTableSQL() {
        return new String[]{this.createJournalTableSQL};
    }

    public static class Factory
    implements SQLProvider.Factory {
        @Override
        public SQLProvider create(String tableName) {
            return new Oracle12CSQLProvider(tableName);
        }
    }
}

