/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreBuilder;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class MixedKeyedJDBCStoreBuilder
extends JDBCStoreBuilder<JdbcMixedStoreConfiguration, JdbcMixedStoreConfigurationBuilder> {
    private final InjectedValue<TableManipulationConfiguration> binaryTable = new InjectedValue();
    private final InjectedValue<TableManipulationConfiguration> stringTable = new InjectedValue();
    private final PathAddress cacheAddress;

    MixedKeyedJDBCStoreBuilder(PathAddress cacheAddress) {
        super(JdbcMixedStoreConfigurationBuilder.class, cacheAddress);
        this.cacheAddress = cacheAddress;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.BINARY_TABLE.getServiceName(this.cacheAddress), TableManipulationConfiguration.class, this.binaryTable).addDependency(CacheComponent.STRING_TABLE.getServiceName(this.cacheAddress), TableManipulationConfiguration.class, this.stringTable);
    }

    @Override
    public void accept(JdbcMixedStoreConfigurationBuilder builder) {
        builder.binaryTable().read((TableManipulationConfiguration)this.binaryTable.getValue());
        builder.stringTable().read((TableManipulationConfiguration)this.stringTable.getValue());
        super.accept(builder);
    }
}

