/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import java.util.Collection;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.microprofile.health.HealthMonitor;
import org.wildfly.extension.microprofile.health.HealthMonitorService;
import org.wildfly.extension.microprofile.health.SubsystemExtension;

public class CheckOperation
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("check", SubsystemExtension.getResourceDescriptionResolver("microprofile-health")).setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.OBJECT).build();

    public static ModelNode computeResult(Collection<HealthCheckResponse> statuses) {
        ModelNode result = new ModelNode();
        boolean globalOutcome = true;
        result.get("checks").setEmptyList();
        for (HealthCheckResponse status : statuses) {
            ModelNode responseNode = new ModelNode();
            responseNode.get("name").set(status.getName());
            HealthCheckResponse.State state = status.getState();
            globalOutcome &= state == HealthCheckResponse.State.UP;
            responseNode.get("state").set(state.toString());
            if (status.getData().isPresent()) {
                responseNode.get("data").setEmptyObject();
                Map attributes = (Map)status.getData().get();
                for (Map.Entry entry : attributes.entrySet()) {
                    responseNode.get("data").get((String)entry.getKey()).set(entry.getValue().toString());
                }
            }
            result.get("checks").add(responseNode);
        }
        result.get("outcome").set(globalOutcome ? "UP" : "DOWN");
        return result;
    }

    public void execute(OperationContext operationContext, ModelNode modelNode) throws OperationFailedException {
        ServiceController healthMonitorService = operationContext.getServiceRegistry(false).getRequiredService(HealthMonitorService.SERVICE_NAME);
        HealthMonitor healthMonitor = (HealthMonitor)HealthMonitor.class.cast(healthMonitorService.getValue());
        Collection<HealthCheckResponse> responses = healthMonitor.check();
        ModelNode result = CheckOperation.computeResult(responses);
        operationContext.getResult().set(result);
    }
}

