/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import org.eclipse.microprofile.health.HealthCheck;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.microprofile.health.HealthMonitor;
import org.wildfly.extension.microprofile.health.HealthMonitorService;

public class HealthCheckHelper {
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"eclipse", "microprofile", "health", "checks"});

    public static void install(OperationContext context, String name, HealthCheck healthCheck) {
        HealthCheckHelper.install(context, ServiceName.of((String[])new String[]{name}), healthCheck);
    }

    public static void install(OperationContext context, ServiceName suffix, HealthCheck healthCheck) {
        HealthCheckService service = new HealthCheckService(healthCheck);
        context.getServiceTarget().addService(BASE_SERVICE_NAME.append(suffix), (Service)service).addDependency(HealthMonitorService.SERVICE_NAME, HealthMonitor.class, (Injector)service.healthMonitor).install();
    }

    public static void uninstall(OperationContext context, String name) {
        HealthCheckHelper.uninstall(context, ServiceName.of((String[])new String[]{name}));
    }

    public static void uninstall(OperationContext context, ServiceName suffix) {
        context.removeService(BASE_SERVICE_NAME.append(suffix));
    }

    private static class HealthCheckService
    implements Service<HealthCheck> {
        private final InjectedValue<HealthMonitor> healthMonitor = new InjectedValue();
        private final HealthCheck healthCheck;

        private HealthCheckService(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        public void start(StartContext startContext) throws StartException {
            ((HealthMonitor)this.healthMonitor.getValue()).addHealthCheck(this.healthCheck);
        }

        public void stop(StopContext stopContext) {
            ((HealthMonitor)this.healthMonitor.getValue()).removeHealthCheck(this.healthCheck);
        }

        public HealthCheck getValue() throws IllegalStateException, IllegalArgumentException {
            return this.healthCheck;
        }
    }
}

