/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Collection;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.health.CheckOperation;
import org.wildfly.extension.microprofile.health.HealthMonitor;
import org.wildfly.extension.microprofile.health.MicroProfileHealthLogger;

public class HealthHttpHandler
implements HttpHandler {
    private final HealthMonitor monitor;

    HealthHttpHandler(HealthMonitor monitor) {
        this.monitor = monitor;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Collection<HealthCheckResponse> responses = this.monitor.check();
        ModelNode result = CheckOperation.computeResult(responses);
        MicroProfileHealthLogger.ROOT_LOGGER.debugf("checking health check: %s", result.toJSONString(true));
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "application/json");
        boolean ok = result.get("outcome").asString() == HealthCheckResponse.State.UP.toString();
        int statusCode = ok ? 200 : 503;
        exchange.setStatusCode(statusCode).getResponseSender().send(result.toJSONString(true));
    }
}

