/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class DependencyProcessor
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.DEPENDENCIES;
    public static final int PRIORITY = 16384;
    public static final ModuleIdentifier MICROPROFILE_HEALTH_API = ModuleIdentifier.create((String)"org.eclipse.microprofile.health.api");
    public static final ModuleIdentifier MICROPROFILE_HEALTH_EXTENSION = ModuleIdentifier.create((String)"org.wildfly.extension.microprofile.health");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.addDependencies(deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MICROPROFILE_HEALTH_API, false, false, true, false));
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MICROPROFILE_HEALTH_EXTENSION, false, false, true, false));
        }
    }
}

