/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import javax.enterprise.inject.spi.Extension;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.microprofile.health.HealthMonitor;
import org.wildfly.extension.microprofile.health.HealthMonitorService;
import org.wildfly.extension.microprofile.health.deployment.CDIExtension;

public class SubsystemDeploymentProcessor
implements DeploymentUnitProcessor {
    Logger log = Logger.getLogger(SubsystemDeploymentProcessor.class);
    public static final Phase PHASE = Phase.POST_MODULE;
    public static final int PRIORITY = 16384;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
            ServiceController healthMonitorService = phaseContext.getServiceRegistry().getRequiredService(HealthMonitorService.SERVICE_NAME);
            HealthMonitor healthMonitor = (HealthMonitor)HealthMonitor.class.cast(healthMonitorService.getValue());
            extensions.registerExtensionInstance((Extension)new CDIExtension(healthMonitor), deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

