/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.query;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.infinispan.util.InvocationAfterCompletion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.TransactionMode;

public class QueryResultsRegionImpl
extends BaseTransactionalDataRegion
implements QueryResultsRegion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(QueryResultsRegionImpl.class);
    private final AdvancedCache evictCache;
    private final AdvancedCache putCache;
    private final AdvancedCache getCache;
    private final ConcurrentMap<SessionImplementor, Map> transactionContext = new ConcurrentHashMap<SessionImplementor, Map>();
    private final boolean putCacheRequiresTransaction;

    public QueryResultsRegionImpl(AdvancedCache cache, String name, TransactionManager transactionManager, InfinispanRegionFactory factory) {
        super(cache, name, transactionManager, null, factory, null);
        boolean localOnly = Caches.isInvalidationCache(cache);
        this.evictCache = localOnly ? Caches.localCache(cache) : cache;
        this.putCache = localOnly ? Caches.failSilentWriteCache(cache, Flag.CACHE_MODE_LOCAL) : Caches.failSilentWriteCache(cache);
        this.getCache = Caches.failSilentReadCache(cache);
        TransactionConfiguration transactionConfiguration = this.putCache.getCacheConfiguration().transaction();
        boolean transactional = transactionConfiguration.transactionMode() != TransactionMode.NON_TRANSACTIONAL;
        boolean bl = this.putCacheRequiresTransaction = transactional && !transactionConfiguration.autoCommit();
        if (transactional) {
            log.useNonTransactionalQueryCache();
        }
    }

    @Override
    protected boolean isRegionAccessStrategyEnabled() {
        return false;
    }

    public void evict(Object key) throws CacheException {
        for (Map map : this.transactionContext.values()) {
            map.remove(key);
        }
        this.evictCache.remove(key);
    }

    public void evictAll() throws CacheException {
        this.transactionContext.clear();
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(SessionImplementor session, Object key) throws CacheException {
        if (!this.checkValid()) {
            return null;
        }
        Object result = null;
        Map map = (Map)this.transactionContext.get(session);
        if (map != null) {
            result = map.get(key);
        }
        if (result == null) {
            result = this.getCache.get(key);
        }
        return result;
    }

    public void put(SessionImplementor session, Object key, Object value) throws CacheException {
        if (this.checkValid()) {
            TransactionCoordinator tc = session.getTransactionCoordinator();
            if (tc != null && tc.isJoined()) {
                tc.getLocalSynchronizations().registerSynchronization((Synchronization)new PostTransactionQueryUpdate(tc, session, key, value));
                HashMap<Object, Object> map = (HashMap<Object, Object>)this.transactionContext.get(session);
                if (map == null) {
                    map = new HashMap<Object, Object>();
                    this.transactionContext.put(session, map);
                }
                map.put(key, value);
                return;
            }
            this.putCache.put(key, value);
        }
    }

    private class PostTransactionQueryUpdate
    extends InvocationAfterCompletion {
        private final SessionImplementor session;
        private final Object key;
        private final Object value;

        public PostTransactionQueryUpdate(TransactionCoordinator tc, SessionImplementor session, Object key, Object value) {
            super(tc, QueryResultsRegionImpl.this.putCache, QueryResultsRegionImpl.this.putCacheRequiresTransaction);
            this.session = session;
            this.key = key;
            this.value = value;
        }

        @Override
        public void afterCompletion(int status) {
            QueryResultsRegionImpl.this.transactionContext.remove(this.session);
            super.afterCompletion(status);
        }

        @Override
        protected void invoke(boolean success, AdvancedCache cache) {
            if (success) {
                cache.put(this.key, this.value);
            }
        }
    }
}

