/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.Properties;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobOperator;

abstract class JobOperationStepHandler
implements OperationStepHandler {
    private final boolean modify;

    protected JobOperationStepHandler() {
        this(true);
    }

    protected JobOperationStepHandler(boolean modify) {
        this.modify = modify;
    }

    public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceController controller = context.getServiceRegistry(this.modify).getService(JobOperationStepHandler.getServiceName(context));
        WildFlyJobOperator jobOperator = (WildFlyJobOperator)controller.getService();
        this.execute(context, operation, jobOperator);
    }

    protected abstract void execute(OperationContext var1, ModelNode var2, WildFlyJobOperator var3) throws OperationFailedException;

    static ModelNode resolveValue(OperationContext context, ModelNode operation, AttributeDefinition attribute) throws OperationFailedException {
        ModelNode value = new ModelNode();
        if (operation.has(attribute.getName())) {
            value.set(operation.get(attribute.getName()));
        }
        return attribute.resolveValue(context, value);
    }

    static Properties resolvePropertyValue(OperationContext context, ModelNode operation, AttributeDefinition attribute) throws OperationFailedException {
        Properties properties = new Properties();
        if (operation.hasDefined(attribute.getName())) {
            JobOperationStepHandler.resolveValue(context, operation, attribute).asPropertyList().forEach(p -> properties.put(p.getName(), p.getValue().asString()));
        }
        return properties;
    }

    static OperationFailedException createOperationFailure(Throwable cause) {
        String msg = cause.getLocalizedMessage();
        BatchLogger.LOGGER.debugf(cause, "Failed to process batch operation: %s", msg);
        return new OperationFailedException(msg, cause);
    }

    private static ServiceName getServiceName(OperationContext context) {
        PathAddress address = context.getCurrentAddress();
        String deploymentName = null;
        String subdeploymentName = null;
        for (PathElement element : address) {
            if ("deployment".equals(element.getKey())) {
                deploymentName = JobOperationStepHandler.getRuntimeName(context, element);
                continue;
            }
            if (!"subdeployment".endsWith(element.getKey())) continue;
            subdeploymentName = element.getValue();
        }
        if (deploymentName == null) {
            throw BatchLogger.LOGGER.couldNotFindDeploymentName(address.toString());
        }
        if (subdeploymentName == null) {
            return BatchServiceNames.jobOperatorServiceName(deploymentName);
        }
        return BatchServiceNames.jobOperatorServiceName(deploymentName, subdeploymentName);
    }

    private static String getRuntimeName(OperationContext context, PathElement element) {
        ModelNode deploymentModel = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{element}), false).getModel();
        if (!deploymentModel.hasDefined("runtime-name")) {
            throw BatchLogger.LOGGER.couldNotFindDeploymentName(context.getCurrentAddress().toString());
        }
        return deploymentModel.get("runtime-name").asString();
    }
}

