/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.weld.WeldResourceDefinition;
import org.jboss.as.weld.WeldSubsystem10Parser;
import org.jboss.as.weld.WeldSubsystem20Parser;
import org.jboss.as.weld.WeldSubsystem30Parser;
import org.jboss.as.weld.WeldSubsystem40Parser;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;

public class WeldExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "weld";
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"weld");
    private static final String RESOURCE_NAME = WeldExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)4, (int)0, (int)0);

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, WeldExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        WeldLogger.ROOT_LOGGER.debug((Object)"Activating Weld Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)WeldResourceDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)WeldSubsystem40Parser.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:weld:1.0", () -> WeldSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:weld:2.0", () -> WeldSubsystem20Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:weld:3.0", () -> WeldSubsystem30Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:weld:4.0", () -> WeldSubsystem40Parser.INSTANCE);
    }

    private void registerTransformers(SubsystemRegistration subsystem) {
        ModelVersion version1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
        ModelVersion version3_0_0 = ModelVersion.create((int)3, (int)0, (int)0);
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystem.getSubsystemVersion());
        ResourceTransformationDescriptionBuilder builder300 = chainedBuilder.createBuilder(subsystem.getSubsystemVersion(), version3_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder300.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{WeldResourceDefinition.THREAD_POOL_SIZE_ATTRIBUTE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WeldResourceDefinition.THREAD_POOL_SIZE_ATTRIBUTE})).end();
        ResourceTransformationDescriptionBuilder builder100 = chainedBuilder.createBuilder(version3_0_0, version1_0_0);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder100.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{WeldResourceDefinition.NON_PORTABLE_MODE_ATTRIBUTE, WeldResourceDefinition.REQUIRE_BEAN_DESCRIPTOR_ATTRIBUTE})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return WeldLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new AttributeDefinition[]{WeldResourceDefinition.NON_PORTABLE_MODE_ATTRIBUTE, WeldResourceDefinition.REQUIRE_BEAN_DESCRIPTOR_ATTRIBUTE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{WeldResourceDefinition.DEVELOPMENT_MODE_ATTRIBUTE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WeldResourceDefinition.DEVELOPMENT_MODE_ATTRIBUTE})).end();
        chainedBuilder.buildAndRegister(subsystem, (ModelVersion[][])new ModelVersion[][]{{version1_0_0, version3_0_0}});
    }
}

