/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.ServicesQueue;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemotingEJBDiscoveryProvider
implements DiscoveryProvider {
    static final RemotingEJBDiscoveryProvider INSTANCE = new RemotingEJBDiscoveryProvider();

    private RemotingEJBDiscoveryProvider() {
        Endpoint.getCurrent();
    }

    public DiscoveryRequest discover(final ServiceType serviceType, final FilterSpec filterSpec, DiscoveryResult result) {
        if (!serviceType.implies(ServiceType.of((String)"ejb", (String)"jboss"))) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        EJBClientContext ejbClientContext = EJBClientContext.getCurrent();
        final RemoteEJBReceiver ejbReceiver = ejbClientContext.getAttachment(RemoteTransportProvider.ATTACHMENT_KEY);
        if (ejbReceiver == null) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        Endpoint endpoint = Endpoint.getCurrent();
        ArrayList<EJBClientConnection> connections = new ArrayList<EJBClientConnection>(ejbClientContext.getConfiguredConnections());
        try (ServicesQueue servicesQueue = Discovery.create((DiscoveryProvider)ejbReceiver.getRemoteTransportProvider().getClusterDiscoveryProvider()).discover(serviceType, null);){
            URI serviceURI = servicesQueue.take();
            while (serviceURI != null) {
                EJBClientConnection.Builder nodeConnectionBuilder = new EJBClientConnection.Builder();
                nodeConnectionBuilder.setDestination(serviceURI);
                connections.add(nodeConnectionBuilder.build());
                serviceURI = servicesQueue.take();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        final AtomicInteger connectionCount = new AtomicInteger(connections.size() + 1);
        final CountingResult countingResult = new CountingResult(connectionCount, result);
        final List<Runnable> cancellers = Collections.synchronizedList(new ArrayList());
        for (EJBClientConnection connection : connections) {
            if (!connection.isForDiscovery()) {
                RemotingEJBDiscoveryProvider.countDown(connectionCount, result);
                continue;
            }
            URI uri = connection.getDestination();
            String scheme = uri.getScheme();
            if (scheme == null || !ejbReceiver.getRemoteTransportProvider().supportsProtocol(scheme) || !endpoint.isValidUriScheme(scheme)) {
                RemotingEJBDiscoveryProvider.countDown(connectionCount, result);
                continue;
            }
            IoFuture future = AccessController.doPrivileged(() -> endpoint.getConnection(uri, "ejb", "jboss"));
            cancellers.add(() -> ((IoFuture)future).cancel());
            future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, DiscoveryResult>(){

                public void handleCancelled(DiscoveryResult discoveryResult) {
                    RemotingEJBDiscoveryProvider.countDown(connectionCount, discoveryResult);
                }

                public void handleFailed(IOException exception, DiscoveryResult discoveryResult) {
                    discoveryResult.reportProblem((Throwable)exception);
                    RemotingEJBDiscoveryProvider.countDown(connectionCount, discoveryResult);
                }

                public void handleDone(Connection data, DiscoveryResult discoveryResult) {
                    IoFuture future = ejbReceiver.serviceHandle.getClientService(data, OptionMap.EMPTY);
                    cancellers.add(() -> ((IoFuture)future).cancel());
                    future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<EJBClientChannel, DiscoveryResult>(){

                        public void handleCancelled(DiscoveryResult discoveryResult) {
                            RemotingEJBDiscoveryProvider.countDown(connectionCount, discoveryResult);
                        }

                        public void handleFailed(IOException exception, DiscoveryResult discoveryResult) {
                            discoveryResult.reportProblem((Throwable)exception);
                            RemotingEJBDiscoveryProvider.countDown(connectionCount, discoveryResult);
                        }

                        public void handleDone(EJBClientChannel clientChannel, DiscoveryResult discoveryResult) {
                            DiscoveryRequest request = clientChannel.getDiscoveryProvider().discover(serviceType, filterSpec, (DiscoveryResult)countingResult);
                            cancellers.add(() -> ((DiscoveryRequest)request).cancel());
                        }
                    }, (Object)discoveryResult);
                }
            }, (Object)result);
        }
        RemotingEJBDiscoveryProvider.countDown(connectionCount, result);
        return () -> {
            List list = cancellers;
            synchronized (list) {
                for (Runnable canceller : cancellers) {
                    canceller.run();
                }
            }
        };
    }

    static void countDown(AtomicInteger connectionCount, DiscoveryResult discoveryResult) {
        if (connectionCount.decrementAndGet() == 0) {
            discoveryResult.complete();
        }
    }

    static class CountingResult
    implements DiscoveryResult {
        private final AtomicInteger connectionCount;
        private final DiscoveryResult discoveryResult;

        CountingResult(AtomicInteger connectionCount, DiscoveryResult discoveryResult) {
            this.connectionCount = connectionCount;
            this.discoveryResult = discoveryResult;
        }

        public void complete() {
            RemotingEJBDiscoveryProvider.countDown(this.connectionCount, this.discoveryResult);
        }

        public void reportProblem(Throwable description) {
            this.discoveryResult.reportProblem(description);
        }

        public void addMatch(ServiceURL serviceURL) {
            this.discoveryResult.addMatch(serviceURL);
        }
    }
}

