/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.OperationHandler;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JChannelFactoryBuilder;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketBindingProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackOperation;
import org.jboss.as.clustering.jgroups.subsystem.StackOperationExecutor;
import org.jboss.as.clustering.jgroups.subsystem.StackServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.TransportRegistration;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class StackResourceDefinition
extends ChildResourceDefinition {
    public static final PathElement WILDCARD_PATH = StackResourceDefinition.pathElement("*");
    @Deprecated
    static final ObjectTypeAttributeDefinition TRANSPORT = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)TransportResourceDefinition.WILDCARD_PATH.getKey(), (AttributeDefinition[])new AttributeDefinition[]{AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition(), TransportResourceDefinition.Attribute.SHARED.getDefinition(), SocketBindingProtocolResourceDefinition.Attribute.SOCKET_BINDING.getDefinition(), TransportResourceDefinition.Attribute.DIAGNOSTICS_SOCKET_BINDING.getDefinition(), TransportResourceDefinition.ThreadingAttribute.DEFAULT_EXECUTOR.getDefinition(), TransportResourceDefinition.ThreadingAttribute.OOB_EXECUTOR.getDefinition(), TransportResourceDefinition.ThreadingAttribute.TIMER_EXECUTOR.getDefinition(), TransportResourceDefinition.ThreadingAttribute.THREAD_FACTORY.getDefinition(), TransportResourceDefinition.Attribute.SITE.getDefinition(), TransportResourceDefinition.Attribute.RACK.getDefinition(), TransportResourceDefinition.Attribute.MACHINE.getDefinition(), AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition()}).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setAllowNull(true).setSuffix(null).build();
    @Deprecated
    static final ObjectTypeAttributeDefinition PROTOCOL = ObjectTypeAttributeDefinition.Builder.of((String)ProtocolResourceDefinition.WILDCARD_PATH.getKey(), (AttributeDefinition[])new AttributeDefinition[]{AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition(), ProtocolResourceDefinition.DeprecatedAttribute.SOCKET_BINDING.getDefinition(), AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition()}).setAllowNull(true).setSuffix("protocol").build();
    @Deprecated
    static final AttributeDefinition PROTOCOLS = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"protocols", (ObjectTypeAttributeDefinition)PROTOCOL).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setAllowNull(true).build();
    private final ResourceServiceBuilderFactory<ChannelFactory> builderFactory = address -> new JChannelFactoryBuilder(address);
    private final boolean allowRuntimeOnlyRegistration;

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"stack", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (JGroupsModel.VERSION_4_1_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode(false)), new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).end();
        }
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            ResourceTransformer transformer = new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    for (String name : resource.getChildrenNames(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        resource.getModel().get(PROTOCOLS.getName()).add(name);
                    }
                    context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource).processChildren(resource);
                }
            };
            builder.setCustomResourceTransformer(transformer);
        }
        if (JGroupsModel.VERSION_2_0_0.requiresTransformation(version)) {
            builder.rejectChildResource(RelayResourceDefinition.PATH);
        } else {
            RelayResourceDefinition.buildTransformation(version, builder);
        }
        TransportResourceDefinition.buildTransformation(version, builder);
        ProtocolRegistration.buildTransformation(version, builder);
    }

    public StackResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH));
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addExtraParameters(new AttributeDefinition[]{TRANSPORT, PROTOCOLS}).addCapabilities(Capability.class).addOperationTranslator(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (operation.hasDefined(TRANSPORT.getName())) {
                    PathAddress address = context.getCurrentAddress();
                    ModelNode transport = operation.get(TRANSPORT.getName());
                    String type = AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.resolveModelAttribute((ExpressionResolver)context, transport).asString();
                    PathElement transportPath = TransportResourceDefinition.pathElement(type);
                    PathAddress transportAddress = address.append(new PathElement[]{transportPath});
                    ModelNode transportOperation = Util.createAddOperation((PathAddress)transportAddress);
                    OperationEntry addOperationEntry = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}), "add");
                    for (AttributeDefinition attribute : addOperationEntry.getOperationDefinition().getParameters()) {
                        String name = attribute.getName();
                        if (!transport.hasDefined(name)) continue;
                        transportOperation.get(name).set(transport.get(name));
                    }
                    context.addStep(transportOperation, addOperationEntry.getOperationHandler(), OperationContext.Stage.MODEL);
                }
            }
        }).addOperationTranslator(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (operation.hasDefined(PROTOCOLS.getName())) {
                    PathAddress address = context.getCurrentAddress();
                    for (ModelNode protocol : operation.get(PROTOCOLS.getName()).asList()) {
                        String type = AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.resolveModelAttribute((ExpressionResolver)context, protocol).asString();
                        PathElement protocolPath = ProtocolResourceDefinition.pathElement(type);
                        PathAddress protocolAddress = address.append(new PathElement[]{protocolPath});
                        ModelNode protocolOperation = Util.createAddOperation((PathAddress)protocolAddress);
                        OperationEntry addOperationEntry = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ProtocolResourceDefinition.WILDCARD_PATH}), "add");
                        for (AttributeDefinition attribute : addOperationEntry.getOperationDefinition().getParameters()) {
                            String name = attribute.getName();
                            if (!protocol.hasDefined(name)) continue;
                            protocolOperation.get(name).set(protocol.get(name));
                        }
                        context.addStep(protocolOperation, addOperationEntry.getOperationHandler(), OperationContext.Stage.MODEL);
                    }
                }
            }
        });
        StackServiceHandler handler = new StackServiceHandler(this.builderFactory);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
        SimpleOperationDefinition legacyAddProtocolOperation = new SimpleOperationDefinitionBuilder("add-protocol", this.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{SocketBindingProtocolResourceDefinition.Attribute.SOCKET_BINDING.getDefinition()}).addParameter(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition()).addParameter(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition()).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion()).build();
        OperationStepHandler legacyAddProtocolHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                PathAddress address = context.getCurrentAddress();
                String protocol = operation.require(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).asString();
                PathElement protocolPath = ProtocolResourceDefinition.pathElement(protocol);
                PathAddress protocolAddress = address.append(new PathElement[]{protocolPath});
                ModelNode protocolOperation = Util.createAddOperation((PathAddress)protocolAddress);
                OperationEntry addOperationEntry = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ProtocolResourceDefinition.WILDCARD_PATH}), "add");
                for (AttributeDefinition attribute : addOperationEntry.getOperationDefinition().getParameters()) {
                    String name = attribute.getName();
                    if (!operation.hasDefined(name)) continue;
                    protocolOperation.get(name).set(operation.get(name));
                }
                context.addStep(protocolOperation, addOperationEntry.getOperationHandler(), OperationContext.Stage.MODEL);
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyAddProtocolOperation, legacyAddProtocolHandler);
        SimpleOperationDefinition legacyRemoveProtocolOperation = new SimpleOperationDefinitionBuilder("remove-protocol", this.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition()}).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion()).build();
        OperationStepHandler legacyRemoveProtocolHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                PathAddress address = context.getCurrentAddress();
                String protocol = operation.require(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).asString();
                PathElement protocolPath = ProtocolResourceDefinition.pathElement(protocol);
                PathAddress protocolAddress = address.append(new PathElement[]{protocolPath});
                ModelNode removeOperation = Util.createRemoveOperation((PathAddress)protocolAddress);
                context.addStep(removeOperation, context.getResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{ProtocolResourceDefinition.WILDCARD_PATH}), "remove"), context.getCurrentStage());
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyRemoveProtocolOperation, legacyRemoveProtocolHandler);
        if (this.allowRuntimeOnlyRegistration) {
            new OperationHandler((OperationExecutor)new StackOperationExecutor(), StackOperation.class).register(registration);
        }
        new TransportRegistration(this.builderFactory).register(registration);
        new ProtocolRegistration(this.builderFactory).register(registration);
        new RelayResourceDefinition(this.builderFactory).register(registration);
    }

    static enum Capability implements CapabilityProvider
    {
        JCHANNEL_FACTORY((UnaryRequirement)JGroupsRequirement.CHANNEL_FACTORY);

        private final org.jboss.as.clustering.controller.Capability capability;

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement, new Requirement[0]);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN, builder -> (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(false)));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, UnaryOperator<SimpleAttributeDefinitionBuilder> configurator) {
            this.definition = ((SimpleAttributeDefinitionBuilder)configurator.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

