/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.net.URI;
import java.util.function.BiFunction;
import javax.naming.NamingException;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.naming.client.CurrentNamingProvider;
import org.wildfly.security.auth.client.PeerIdentity;

public interface NamingProvider
extends AutoCloseable {
    public URI getProviderUri();

    public PeerIdentity getPeerIdentityForNaming() throws NamingException;

    public static NamingProvider getCurrentNamingProvider() {
        return CurrentNamingProvider.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, U, R> R performAction(BiFunction<T, U, R> function, T arg1, U arg2) {
        NamingProvider old = CurrentNamingProvider.getAndSetCurrent(this);
        try {
            R r = function.apply(arg1, arg2);
            return r;
        }
        finally {
            CurrentNamingProvider.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, U, R, E extends Exception> R performExceptionAction(ExceptionBiFunction<T, U, R, E> function, T arg1, U arg2) throws E {
        NamingProvider old = CurrentNamingProvider.getAndSetCurrent(this);
        try {
            Object object = function.apply(arg1, arg2);
            return (R)object;
        }
        finally {
            CurrentNamingProvider.setCurrent(old);
        }
    }

    @Override
    default public void close() throws NamingException {
    }
}

