/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.IntUnaryOperator;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.ClientServiceHandle;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.util.BlockingInvocation;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.InvocationTracker;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.MarshallingCompatibilityHelper;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.AggregateObjectResolver;
import org.wildfly.naming.client.remote.ProtocolUtils;
import org.wildfly.naming.client.remote.RemoteContext;
import org.wildfly.naming.client.remote.RemoteTransport;
import org.wildfly.naming.client.remote.TCCLUtils;
import org.wildfly.naming.client.store.RelativeFederatingContext;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

final class RemoteClientTransport
implements RemoteTransport {
    static final ClientServiceHandle<RemoteClientTransport> SERVICE_HANDLE = new ClientServiceHandle("naming", RemoteClientTransport::construct);
    private static final byte[] initialBytes = new byte[]{110, 97, 109, 105, 110, 103};
    private final MarshallingConfiguration configuration;
    private final InvocationTracker tracker;
    private final Channel channel;
    private final int version;

    RemoteClientTransport(Channel channel, int version, MarshallingConfiguration configuration) {
        configuration.setClassResolver((ClassResolver)new ContextClassResolver());
        this.channel = channel;
        this.configuration = configuration;
        this.version = version;
        this.tracker = new InvocationTracker(channel, version == 1 ? IntUnaryOperator.identity() : RemoteClientTransport::defaultFunction);
    }

    @Override
    public Connection getConnection() {
        return this.channel.getConnection();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    MarshallingConfiguration getConfiguration() {
        return this.configuration;
    }

    private static int defaultFunction(int random) {
        return random & 0xFFFF;
    }

    private static IoFuture<RemoteClientTransport> construct(final Channel channel) {
        final FutureResult futureResult = new FutureResult((Executor)channel.getConnection().getEndpoint().getXnioWorker());
        channel.receiveMessage(new Channel.Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleError(Channel channel, IOException error) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    futureResult.setException(error);
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }

            public void handleEnd(Channel channel) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    futureResult.setCancelled();
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handleMessage(Channel channel, MessageInputStream message) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try (MessageInputStream mis = message;){
                    int version;
                    byte[] namingHeader = new byte[ProtocolUtils.NAMING_BYTES.length];
                    mis.read(namingHeader);
                    if (!Arrays.equals(namingHeader, ProtocolUtils.NAMING_BYTES)) {
                        futureResult.setException(new IOException(Messages.log.invalidHeader()));
                        return;
                    }
                    int length = mis.readUnsignedByte();
                    boolean hasOne = false;
                    boolean hasTwo = false;
                    for (int i = 0; i < length; ++i) {
                        int v = mis.readUnsignedByte() & 0x7F;
                        if (v == 1) {
                            hasOne = true;
                            continue;
                        }
                        if (v != 2) continue;
                        hasTwo = true;
                    }
                    if (hasTwo) {
                        version = 2;
                    } else {
                        if (!hasOne) {
                            futureResult.setException(new IOException(Messages.log.noCompatibleVersions()));
                            return;
                        }
                        version = 1;
                    }
                    MarshallingConfiguration configuration = new MarshallingConfiguration();
                    configuration.setVersion(version == 2 ? 4 : 2);
                    RemoteClientTransport remoteClientTransport = new RemoteClientTransport(channel, version, configuration);
                    List<MarshallingCompatibilityHelper> helpers = ProtocolUtils.getMarshallingCompatibilityHelpers();
                    ObjectResolver resolver = null;
                    for (MarshallingCompatibilityHelper helper : helpers) {
                        ObjectResolver nextResolver = helper.getObjectResolver(remoteClientTransport, true);
                        if (resolver == null) {
                            resolver = nextResolver;
                            continue;
                        }
                        if (resolver instanceof AggregateObjectResolver) {
                            ((AggregateObjectResolver)resolver).add(nextResolver);
                            continue;
                        }
                        resolver = new AggregateObjectResolver().add(nextResolver);
                    }
                    if (resolver != null) {
                        remoteClientTransport.getConfiguration().setObjectResolver(resolver);
                    }
                    try (MessageOutputStream os = remoteClientTransport.tracker.allocateMessage();){
                        os.write(ProtocolUtils.NAMING_BYTES);
                        os.writeByte(version);
                    }
                    remoteClientTransport.start();
                    futureResult.setResult((Object)remoteClientTransport);
                    return;
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)channel);
                    futureResult.setException(new IOException(Messages.log.connectFailed(e)));
                    return;
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }
        });
        futureResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                if (futureResult.setCancelled()) {
                    IoUtils.safeClose((Closeable)channel);
                }
                return this;
            }
        });
        return futureResult.getIoFuture();
    }

    void start() {
        this.channel.receiveMessage(new Channel.Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleError(Channel channel, IOException error) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    IoUtils.safeClose((Closeable)channel);
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }

            public void handleEnd(Channel channel) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    IoUtils.safeClose((Closeable)channel);
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Channel channel, MessageInputStream message) {
                ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
                try {
                    int messageId = message.readUnsignedByte();
                    int id = ProtocolUtils.readId(message, RemoteClientTransport.this.version);
                    int result = message.readUnsignedByte();
                    if (result != 0 && result != 1) {
                        throw Messages.log.outcomeNotUnderstood();
                    }
                    RemoteClientTransport.this.tracker.signalResponse(id, messageId, message, true);
                    channel.receiveMessage((Channel.Receiver)this);
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)channel);
                    IoUtils.safeClose((Closeable)message);
                }
                finally {
                    TCCLUtils.resetTCCL(oldCL);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object lookup(RemoteContext context, Name name, ConnectionPeerIdentity peerIdentity, boolean preserveLinks) throws NamingException {
        int authId = peerIdentity.getId();
        int version = this.version;
        if (version == 1 && authId != 0) {
            throw Messages.log.connectionSharingUnsupported();
        }
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block38: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(preserveLinks ? 16 : 1);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        try (Marshaller marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(name));
                            break block38;
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(name).toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            MessageInputStream is = response.getInputStream();
            int parameterType = is.readUnsignedByte();
            if (parameterType == 5) {
                RelativeFederatingContext relativeFederatingContext = new RelativeFederatingContext(new FastHashtable<String, Object>(context.getEnvironment()), context, NamingUtils.toCompositeName(name));
                return relativeFederatingContext;
            }
            if (parameterType == 1) {
                try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);){
                    Object object = unmarshaller.readObject();
                    return object;
                }
            }
            if (parameterType != 2) throw Messages.log.invalidResponse();
            Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);
            try {
                Exception exception = (Exception)unmarshaller.readObject(Exception.class);
                if (!(exception instanceof NamingException)) throw NamingUtils.namingException("Failed to lookup", exception);
                throw (NamingException)exception;
            }
            catch (Throwable throwable) {
                if (unmarshaller == null) throw throwable;
                try {
                    unmarshaller.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw NamingUtils.namingException("Failed to lookup", e);
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void bind(Name name, Object obj, ConnectionPeerIdentity peerIdentity, boolean rebind) throws NamingException {
        int authId = peerIdentity.getId();
        int version = this.version;
        if (version == 1 && authId != 0) {
            throw Messages.log.connectionSharingUnsupported();
        }
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block38: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    Marshaller marshaller;
                    messageOutputStream.writeByte(rebind ? 3 : 2);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);
                        try {
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(name));
                            marshaller.writeByte(1);
                            marshaller.writeObject(obj);
                            break block38;
                        }
                        finally {
                            if (marshaller != null) {
                                marshaller.close();
                            }
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(name).toString());
                    marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);
                    try {
                        marshaller.writeObject(obj);
                    }
                    finally {
                        if (marshaller != null) {
                            marshaller.close();
                        }
                    }
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try {
                MessageInputStream is = response.getInputStream();
                try {
                    int parameterType = is.readUnsignedByte();
                    if (parameterType == 2) {
                        Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);
                        try {
                            Exception exception = (Exception)unmarshaller.readObject(Exception.class);
                            if (exception instanceof NamingException) {
                                throw (NamingException)exception;
                            }
                            throw NamingUtils.namingException("Failed to bind", exception);
                        }
                        catch (Throwable throwable) {
                            if (unmarshaller != null) {
                                try {
                                    unmarshaller.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    throw Messages.log.invalidResponse();
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (ClassNotFoundException e) {
            throw NamingUtils.namingException("Failed to bind", e);
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void unbind(Name name, ConnectionPeerIdentity peerIdentity) throws NamingException {
        int authId = peerIdentity.getId();
        int version = this.version;
        if (version == 1 && authId != 0) {
            throw Messages.log.connectionSharingUnsupported();
        }
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block32: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(6);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        try (Marshaller marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(name));
                            break block32;
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(name).toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try {
                MessageInputStream is = response.getInputStream();
                try {
                    int parameterType = is.readUnsignedByte();
                    if (parameterType == 2) {
                        Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);
                        try {
                            Exception exception = (Exception)unmarshaller.readObject(Exception.class);
                            if (exception instanceof NamingException) {
                                throw (NamingException)exception;
                            }
                            throw NamingUtils.namingException("Failed to unbind", exception);
                        }
                        catch (Throwable throwable) {
                            if (unmarshaller != null) {
                                try {
                                    unmarshaller.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    throw Messages.log.invalidResponse();
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (ClassNotFoundException e) {
            throw NamingUtils.namingException("Failed to unbind", e);
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void rename(Name oldName, Name newName, ConnectionPeerIdentity peerIdentity) throws NamingException {
        int authId = peerIdentity.getId();
        int version = this.version;
        if (version == 1 && authId != 0) {
            throw Messages.log.connectionSharingUnsupported();
        }
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block32: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(7);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        try (Marshaller marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(oldName));
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(newName));
                            break block32;
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(oldName).toString());
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(newName).toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try {
                MessageInputStream is = response.getInputStream();
                try {
                    int parameterType = is.readUnsignedByte();
                    if (parameterType == 2) {
                        Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);
                        try {
                            Exception exception = (Exception)unmarshaller.readObject(Exception.class);
                            if (exception instanceof NamingException) {
                                throw (NamingException)exception;
                            }
                            throw NamingUtils.namingException("Failed to rename", exception);
                        }
                        catch (Throwable throwable) {
                            if (unmarshaller != null) {
                                try {
                                    unmarshaller.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    throw Messages.log.invalidResponse();
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (ClassNotFoundException e) {
            throw NamingUtils.namingException("Failed to rename", e);
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void destroySubcontext(Name name, ConnectionPeerIdentity peerIdentity) throws NamingException {
        int authId = peerIdentity.getId();
        int version = this.version;
        if (version == 1 && authId != 0) {
            throw Messages.log.connectionSharingUnsupported();
        }
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block32: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(9);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        try (Marshaller marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(name));
                            break block32;
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(name).toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try {
                MessageInputStream is = response.getInputStream();
                try {
                    int parameterType = is.readUnsignedByte();
                    if (parameterType == 2) {
                        Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);
                        try {
                            Exception exception = (Exception)unmarshaller.readObject(Exception.class);
                            if (exception instanceof NamingException) {
                                throw (NamingException)exception;
                            }
                            throw NamingUtils.namingException("Failed to destroySubcontext", exception);
                        }
                        catch (Throwable throwable) {
                            if (unmarshaller != null) {
                                try {
                                    unmarshaller.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    throw Messages.log.invalidResponse();
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (ClassNotFoundException e) {
            throw NamingUtils.namingException("Failed to destroySubcontext", e);
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void createSubcontext(CompositeName compositeName, ConnectionPeerIdentity peerIdentity) throws NamingException {
        int authId = peerIdentity.getId();
        int version = this.version;
        if (version == 1 && authId != 0) {
            throw Messages.log.connectionSharingUnsupported();
        }
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block32: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(8);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        try (Marshaller marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)compositeName);
                            break block32;
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(compositeName.toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try {
                MessageInputStream is = response.getInputStream();
                try {
                    int parameterType = is.readUnsignedByte();
                    if (parameterType == 2) {
                        Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);
                        try {
                            Exception exception = (Exception)unmarshaller.readObject(Exception.class);
                            if (exception instanceof NamingException) {
                                throw (NamingException)exception;
                            }
                            throw NamingUtils.namingException("Failed to createSubcontext", exception);
                        }
                        catch (Throwable throwable) {
                            if (unmarshaller != null) {
                                try {
                                    unmarshaller.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    throw Messages.log.invalidResponse();
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (ClassNotFoundException e) {
            throw NamingUtils.namingException("Failed to createSubcontext", e);
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CloseableNamingEnumeration<NameClassPair> list(Name name, ConnectionPeerIdentity peerIdentity) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        int authId = peerIdentity.getId();
        int version = this.version;
        if (version == 1 && authId != 0) {
            throw Messages.log.connectionSharingUnsupported();
        }
        CompositeName compositeName = NamingUtils.toCompositeName(name);
        try {
            block35: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(4);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        try (Marshaller marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(name));
                            break block35;
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(compositeName.toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try (MessageInputStream is = response.getInputStream();){
                if (version == 1) {
                    if (is.readUnsignedByte() != 6) {
                        throw Messages.log.invalidResponse();
                    }
                    int listSize = is.readInt();
                    ArrayList<NameClassPair> results = new ArrayList<NameClassPair>(listSize);
                    try (Object unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);){
                        for (int i = 0; i < listSize; ++i) {
                            results.add((NameClassPair)unmarshaller.readObject(NameClassPair.class));
                        }
                    }
                    unmarshaller = CloseableNamingEnumeration.fromIterable(results);
                    return unmarshaller;
                }
                int listSize = is.readInt();
                ArrayList<NameClassPair> results = new ArrayList<NameClassPair>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    String itemName = is.readUTF();
                    String itemClass = is.readUTF();
                    NameClassPair nameClassPair = new NameClassPair(itemName, itemClass, true);
                    CompositeName inNamespace = (CompositeName)compositeName.clone();
                    inNamespace.add(itemName);
                    nameClassPair.setNameInNamespace(inNamespace.toString());
                    results.add(nameClassPair);
                }
                CloseableNamingEnumeration<NameClassPair> closeableNamingEnumeration = CloseableNamingEnumeration.fromIterable(results);
                return closeableNamingEnumeration;
            }
        }
        catch (ClassNotFoundException e) {
            throw NamingUtils.namingException("Failed to lookup", e);
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    CloseableNamingEnumeration<Binding> listBindings(Name name, RemoteContext remoteContext, ConnectionPeerIdentity peerIdentity) throws NamingException {
        CloseableNamingEnumeration<Binding> closeableNamingEnumeration;
        block36: {
            CompositeName compositeName;
            BlockingInvocation invocation;
            int version;
            block34: {
                int authId = peerIdentity.getId();
                version = this.version;
                if (version == 1 && authId != 0) {
                    throw Messages.log.connectionSharingUnsupported();
                }
                invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
                compositeName = NamingUtils.toCompositeName(name);
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(5);
                    ProtocolUtils.writeId(messageOutputStream, version, invocation.getIndex());
                    if (version == 1) {
                        try (Marshaller marshaller = ProtocolUtils.createMarshaller(messageOutputStream, this.configuration);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)NamingUtils.toDecomposedCompositeName(name));
                            break block34;
                        }
                    }
                    messageOutputStream.writeInt(authId);
                    messageOutputStream.writeUTF(compositeName.toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            MessageInputStream is = response.getInputStream();
            try {
                if (version == 1 && is.readUnsignedByte() != 6) {
                    throw Messages.log.invalidResponse();
                }
                int listSize = is.readInt();
                ArrayList<Binding> results = new ArrayList<Binding>(listSize);
                try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(is, this.configuration);){
                    for (int i = 0; i < listSize; ++i) {
                        int b = unmarshaller.readUnsignedByte();
                        if (b == 5) {
                            CompositeName prefix = (CompositeName)compositeName.clone();
                            String relName = unmarshaller.readUTF();
                            prefix.add(relName);
                            RelativeFederatingContext context = new RelativeFederatingContext(new FastHashtable<String, Object>(remoteContext.getEnvironment()), remoteContext, prefix);
                            results.add(new Binding(relName, context, true));
                            continue;
                        }
                        if (b == 4) {
                            results.add((Binding)unmarshaller.readObject(Binding.class));
                            continue;
                        }
                        throw Messages.log.invalidResponse();
                    }
                }
                closeableNamingEnumeration = CloseableNamingEnumeration.fromIterable(results);
                if (is == null) break block36;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw NamingUtils.namingException("Failed to lookup", e);
                }
                catch (IOException e) {
                    throw Messages.log.operationFailed(e);
                }
                catch (InterruptedException e) {
                    invocation.cancel();
                    Thread.currentThread().interrupt();
                    throw Messages.log.operationInterrupted();
                }
            }
            is.close();
        }
        return closeableNamingEnumeration;
    }
}

