/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.java.permission;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jboss.as.naming.logging.NamingLogger;
import org.wildfly.common.iteration.CodePointIterator;

final class JndiPermissionNameParser {
    private JndiPermissionNameParser() {
    }

    static Iterator<String> nameIterator(String string) {
        return new ParsingIterator(string);
    }

    static Iterator<String> segmentsIterator(String[] segments) {
        return new SegmentsIterator(segments);
    }

    static String[] toArray(Iterator<String> iter) {
        return JndiPermissionNameParser.toArray(iter, 0);
    }

    private static String[] toArray(Iterator<String> iter, int size) {
        if (iter.hasNext()) {
            String next = iter.next();
            String[] array = JndiPermissionNameParser.toArray(iter, size + 1);
            array[size] = next;
            return array;
        }
        return new String[size];
    }

    static class ParsingIterator
    implements Iterator<String> {
        private final CodePointIterator cpi;
        private final StringBuilder b;
        private final String string;
        private boolean hasNext = true;

        ParsingIterator(String string) {
            this.string = string;
            this.cpi = CodePointIterator.ofString((String)string);
            this.b = new StringBuilder();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuilder b = this.b;
            CodePointIterator cpi = this.cpi;
            block0: while (cpi.hasNext()) {
                int cp = cpi.next();
                if (cp == 92) {
                    if (!cpi.hasNext()) {
                        throw NamingLogger.ROOT_LOGGER.invalidJndiName(this.string);
                    }
                    b.appendCodePoint(cpi.next());
                    continue;
                }
                if (cp == 34 || cp == 39) {
                    int q = cp;
                    if (!cpi.hasNext()) {
                        throw NamingLogger.ROOT_LOGGER.invalidJndiName(this.string);
                    }
                    do {
                        if ((cp = cpi.next()) == 92) {
                            if (!cpi.hasNext()) {
                                throw NamingLogger.ROOT_LOGGER.invalidJndiName(this.string);
                            }
                            b.appendCodePoint(cpi.next());
                            continue;
                        }
                        if (cp == q) continue block0;
                        b.appendCodePoint(cp);
                    } while (cpi.hasNext());
                    throw NamingLogger.ROOT_LOGGER.invalidJndiName(this.string);
                }
                if (cp == 47) {
                    String s = b.toString();
                    b.setLength(0);
                    return s;
                }
                b.appendCodePoint(cp);
            }
            String s = b.toString();
            b.setLength(0);
            this.hasNext = false;
            return s;
        }
    }

    static class SegmentsIterator
    implements Iterator<String> {
        private final String[] segments;
        private int idx;

        SegmentsIterator(String[] segments) {
            this.segments = segments;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.segments.length;
        }

        @Override
        public String next() {
            return this.segments[this.idx++];
        }

        String[] getSegments() {
            return this.segments;
        }
    }
}

