package org.jboss.as.naming.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.naming.deployment.JndiName;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.naming.Name;
import java.lang.RuntimeException;
import javax.naming.InvalidNameException;
import org.jboss.as.naming.subsystem.BindingType;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.ClassLoader;
import javax.naming.NamingException;
import org.jboss.modules.ModuleIdentifier;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.naming.Context;
import javax.annotation.Generated;
import javax.naming.NameNotFoundException;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import org.jboss.msc.service.ServiceName;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-09-05T17:25:07-0700")
public class NamingLogger_$logger extends DelegatingBasicLogger implements NamingLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = NamingLogger_$logger.class.getName();
    public NamingLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    private static final String activatingSubsystem = "WFLYNAM0001: Activating Naming Subsystem";
    protected String activatingSubsystem$str() {
        return activatingSubsystem;
    }
    @Override
    public final void failedToSet(final Throwable cause, final String name) {
        super.log.logf(FQCN, WARN, cause, failedToSet$str(), name);
    }
    private static final String failedToSet = "WFLYNAM0002: Failed to set %s";
    protected String failedToSet$str() {
        return failedToSet;
    }
    @Override
    public final void startingService() {
        super.log.logf(FQCN, INFO, null, startingService$str());
    }
    private static final String startingService = "WFLYNAM0003: Starting Naming Service";
    protected String startingService$str() {
        return startingService;
    }
    @Override
    public final void failedToReleaseBinderService(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToReleaseBinderService$str());
    }
    private static final String failedToReleaseBinderService = "WFLYNAM0012: Failed to release binder service, used for a runtime made JNDI binding";
    protected String failedToReleaseBinderService$str() {
        return failedToReleaseBinderService;
    }
    @Override
    public final void failedToLookupJndiViewValue(final String entry, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToLookupJndiViewValue$str(), entry);
    }
    private static final String failedToLookupJndiViewValue = "WFLYNAM0013: Failed to obtain jndi view value for entry %s.";
    protected String failedToLookupJndiViewValue$str() {
        return failedToLookupJndiViewValue;
    }
    private static final String cannotAddToReadOnlyPermissionCollection = "WFLYNAM0014: Attempt to add a Permission to a readonly PermissionCollection";
    protected String cannotAddToReadOnlyPermissionCollection$str() {
        return cannotAddToReadOnlyPermissionCollection;
    }
    @Override
    public final SecurityException cannotAddToReadOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), cannotAddToReadOnlyPermissionCollection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBeNull = "WFLYNAM0015: %s cannot be null.";
    protected String cannotBeNull$str() {
        return cannotBeNull;
    }
    @Override
    public final String cannotBeNull(final String name) {
        return String.format(getLoggingLocale(), cannotBeNull$str(), name);
    }
    private static final String cannotDeferenceObject = "WFLYNAM0016: Could not dereference object";
    protected String cannotDeferenceObject$str() {
        return cannotDeferenceObject;
    }
    @Override
    public final NamingException cannotDeferenceObject(final Throwable cause) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), cannotDeferenceObject$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotListNonContextBinding = "WFLYNAM0017: Unable to list a non Context binding.";
    protected String cannotListNonContextBinding$str() {
        return cannotListNonContextBinding;
    }
    @Override
    public final NamingException cannotListNonContextBinding() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), cannotListNonContextBinding$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLookupLink = "WFLYNAM0018: Could not lookup link";
    protected String cannotLookupLink$str() {
        return cannotLookupLink;
    }
    @Override
    public final String cannotLookupLink() {
        return String.format(getLoggingLocale(), cannotLookupLink$str());
    }
    private static final String cannotResolveService1 = "WFLYNAM0020: Could not resolve service %s";
    protected String cannotResolveService1$str() {
        return cannotResolveService1;
    }
    @Override
    public final NamingException cannotResolveService(final ServiceName serviceName) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), cannotResolveService1$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResolveService3 = "WFLYNAM0021: Could not resolve service reference to %s in factory %s. Service was in state %s.";
    protected String cannotResolveService3$str() {
        return cannotResolveService3;
    }
    @Override
    public final NamingException cannotResolveService(final ServiceName serviceName, final String className, final String state) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), cannotResolveService3$str(), serviceName, className, state));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResolveServiceBug = "WFLYNAM0022: Could not resolve service reference to %s in factory %s. This is a bug in ServiceReferenceObjectFactory. State was %s.";
    protected String cannotResolveServiceBug$str() {
        return cannotResolveServiceBug;
    }
    @Override
    public final NamingException cannotResolveServiceBug(final ServiceName serviceName, final String className, final String state) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), cannotResolveServiceBug$str(), serviceName, className, state));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateBinding = "WFLYNAM0023: Duplicate JNDI bindings for '%s' are not compatible.  [%s] != [%s]";
    protected String duplicateBinding$str() {
        return duplicateBinding;
    }
    @Override
    public final String duplicateBinding(final JndiName jndiName, final Object existing, final Object value) {
        return String.format(getLoggingLocale(), duplicateBinding$str(), jndiName, existing, value);
    }
    private static final String emptyNameNotAllowed = "WFLYNAM0024: An empty name is not allowed";
    protected String emptyNameNotAllowed$str() {
        return emptyNameNotAllowed;
    }
    @Override
    public final InvalidNameException emptyNameNotAllowed() {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), emptyNameNotAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String entryNotRegistered = "WFLYNAM0025: Jndi entry '%s' is not yet registered in context '%s'";
    protected String entryNotRegistered$str() {
        return entryNotRegistered;
    }
    @Override
    public final IllegalStateException entryNotRegistered(final Throwable cause, final String contextName, final Context context) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), entryNotRegistered$str(), contextName, context), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToDestroyRootContext = "WFLYNAM0026: Failed to destroy root context";
    protected String failedToDestroyRootContext$str() {
        return failedToDestroyRootContext;
    }
    @Override
    public final IllegalStateException failedToDestroyRootContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToDestroyRootContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToInstantiate = "WFLYNAM0027: Failed instantiate %s %s from classloader %s";
    protected String failedToInstantiate$str() {
        return failedToInstantiate;
    }
    @Override
    public final NamingException failedToInstantiate(final Throwable cause, final String description, final String className, final ClassLoader classLoader) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), failedToInstantiate$str(), description, className, classLoader));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadContextEntries = "WFLYNAM0028: Failed to read %s context entries.";
    protected String failedToReadContextEntries$str() {
        return failedToReadContextEntries;
    }
    @Override
    public final String failedToReadContextEntries(final String bindingName) {
        return String.format(getLoggingLocale(), failedToReadContextEntries$str(), bindingName);
    }
    private static final String failedToStart = "WFLYNAM0029: Failed to start %s";
    protected String failedToStart$str() {
        return failedToStart;
    }
    @Override
    public final String failedToStart(final String name) {
        return String.format(getLoggingLocale(), failedToStart$str(), name);
    }
    private static final String illegalContextInName = "WFLYNAM0030: Illegal context in name: %s";
    protected String illegalContextInName$str() {
        return illegalContextInName;
    }
    @Override
    public final RuntimeException illegalContextInName(final String jndiName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), illegalContextInName$str(), jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidContextReference = "WFLYNAM0032: Invalid context reference.  Not a '%s' reference.";
    protected String invalidContextReference$str() {
        return invalidContextReference;
    }
    @Override
    public final NamingException invalidContextReference(final String referenceName) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), invalidContextReference$str(), referenceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidJndiName = "WFLYNAM0033: A valid JNDI name must be provided: %s";
    protected String invalidJndiName$str() {
        return invalidJndiName;
    }
    @Override
    public final IllegalArgumentException invalidJndiName(final String jndiName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidJndiName$str(), jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidLoadFactor = "WFLYNAM0034: Load factor must be greater than 0 and less than or equal to 1";
    protected String invalidLoadFactor$str() {
        return invalidLoadFactor;
    }
    @Override
    public final IllegalArgumentException invalidLoadFactor() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidLoadFactor$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermission = "WFLYNAM0035: invalid permission, unknown action: %s";
    protected String invalidPermission$str() {
        return invalidPermission;
    }
    @Override
    public final IllegalArgumentException invalidPermission(final Permission permission) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermission$str(), permission));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermissionAction = "WFLYNAM0036: invalid permission, unknown action: %s";
    protected String invalidPermissionAction$str() {
        return invalidPermissionAction;
    }
    @Override
    public final IllegalArgumentException invalidPermissionAction(final String permissionAction) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermissionAction$str(), permissionAction));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTableSize = "WFLYNAM0037: Can not have a negative size table!";
    protected String invalidTableSize$str() {
        return invalidTableSize;
    }
    @Override
    public final IllegalArgumentException invalidTableSize() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTableSize$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiViewNotAvailable = "WFLYNAM0038: Jndi view is only available in runtime mode.";
    protected String jndiViewNotAvailable$str() {
        return jndiViewNotAvailable;
    }
    @Override
    public final String jndiViewNotAvailable() {
        return String.format(getLoggingLocale(), jndiViewNotAvailable$str());
    }
    private static final String nameNotFoundInContext = "WFLYNAM0039: Name '%s' not found in context '%s'";
    protected String nameNotFoundInContext$str() {
        return nameNotFoundInContext;
    }
    @Override
    public final NameNotFoundException nameNotFoundInContext(final String name, final Name contextName) {
        final NameNotFoundException result = new NameNotFoundException(String.format(getLoggingLocale(), nameNotFoundInContext$str(), name, contextName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullVar = "WFLYNAM0041: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final IllegalArgumentException nullVar(final String varName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullVar$str(), varName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String objectFactoryCreationFailure = "WFLYNAM0042: Failed to create object factory from classloader.";
    protected String objectFactoryCreationFailure$str() {
        return objectFactoryCreationFailure;
    }
    @Override
    public final NamingException objectFactoryCreationFailure(final Throwable cause) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), objectFactoryCreationFailure$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readOnlyNamingContext = "WFLYNAM0043: Naming context is read-only";
    protected String readOnlyNamingContext$str() {
        return readOnlyNamingContext;
    }
    @Override
    public final UnsupportedOperationException readOnlyNamingContext() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), readOnlyNamingContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceAlreadyBound = "WFLYNAM0044: Service with name [%s] already bound.";
    protected String serviceAlreadyBound$str() {
        return serviceAlreadyBound;
    }
    @Override
    public final IllegalArgumentException serviceAlreadyBound(final ServiceName serviceName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), serviceAlreadyBound$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tableIsFull = "WFLYNAM0045: Table is full!";
    protected String tableIsFull$str() {
        return tableIsFull;
    }
    @Override
    public final IllegalStateException tableIsFull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tableIsFull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String threadInterrupt = "WFLYNAM0046: Thread interrupted while retrieving service reference for service %s";
    protected String threadInterrupt$str() {
        return threadInterrupt;
    }
    @Override
    public final NamingException threadInterrupt(final ServiceName serviceName) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), threadInterrupt$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNameForContextBinding = "WFLYNAM0047: Invalid name for context binding %s";
    protected String invalidNameForContextBinding$str() {
        return invalidNameForContextBinding;
    }
    @Override
    public final DeploymentUnitProcessingException invalidNameForContextBinding(final String name) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidNameForContextBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNamespaceForBinding = "WFLYNAM0048: Invalid binding name %s, name must start with one of %s";
    protected String invalidNamespaceForBinding$str() {
        return invalidNamespaceForBinding;
    }
    @Override
    public final OperationFailedException invalidNamespaceForBinding(final String name, final String namespaces) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidNamespaceForBinding$str(), name, namespaces));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownBindingType = "WFLYNAM0049: Unknown binding type %s";
    protected String unknownBindingType$str() {
        return unknownBindingType;
    }
    @Override
    public final OperationFailedException unknownBindingType(final String type) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unknownBindingType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedSimpleBindingType = "WFLYNAM0050: Unsupported simple binding type %s";
    protected String unsupportedSimpleBindingType$str() {
        return unsupportedSimpleBindingType;
    }
    @Override
    public final OperationFailedException unsupportedSimpleBindingType(final String type) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unsupportedSimpleBindingType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToTransformURLBindingValue = "WFLYNAM0051: Unable to transform URL binding value %s";
    protected String unableToTransformURLBindingValue$str() {
        return unableToTransformURLBindingValue;
    }
    @Override
    public final OperationFailedException unableToTransformURLBindingValue(final String value, final Throwable cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToTransformURLBindingValue$str(), value), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotLoadModule = "WFLYNAM0052: Could not load module %s";
    protected String couldNotLoadModule$str() {
        return couldNotLoadModule;
    }
    @Override
    public final OperationFailedException couldNotLoadModule(final ModuleIdentifier moduleID) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), couldNotLoadModule$str(), moduleID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotLoadClassFromModule = "WFLYNAM0053: Could not load class %s from module %s";
    protected String couldNotLoadClassFromModule$str() {
        return couldNotLoadClassFromModule;
    }
    @Override
    public final OperationFailedException couldNotLoadClassFromModule(final String className, final ModuleIdentifier moduleID) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), couldNotLoadClassFromModule$str(), className, moduleID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotInstantiateClassInstanceFromModule = "WFLYNAM0054: Could not instantiate instance of class %s from module %s";
    protected String couldNotInstantiateClassInstanceFromModule$str() {
        return couldNotInstantiateClassInstanceFromModule;
    }
    @Override
    public final OperationFailedException couldNotInstantiateClassInstanceFromModule(final String className, final ModuleIdentifier moduleID) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), couldNotInstantiateClassInstanceFromModule$str(), className, moduleID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnInstanceOfObjectFactory = "WFLYNAM0055: Class %s from module %s is not an instance of ObjectFactory";
    protected String notAnInstanceOfObjectFactory$str() {
        return notAnInstanceOfObjectFactory;
    }
    @Override
    public final OperationFailedException notAnInstanceOfObjectFactory(final String className, final ModuleIdentifier moduleID) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), notAnInstanceOfObjectFactory$str(), className, moduleID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String resourceLookupForInjectionFailed = "WFLYNAM0059: Resource lookup for injection failed: %s";
    protected String resourceLookupForInjectionFailed$str() {
        return resourceLookupForInjectionFailed;
    }
    @Override
    public final RuntimeException resourceLookupForInjectionFailed(final String jndiName, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), resourceLookupForInjectionFailed$str(), jndiName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bindingTypeRequiresAttributeDefined = "WFLYNAM0060: Binding type %s requires attribute named %s defined";
    protected String bindingTypeRequiresAttributeDefined$str() {
        return bindingTypeRequiresAttributeDefined;
    }
    @Override
    public final OperationFailedException bindingTypeRequiresAttributeDefined(final BindingType bindingType, final String attributeName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), bindingTypeRequiresAttributeDefined$str(), bindingType, attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheNotValidForBindingType = "WFLYNAM0061: Binding type %s can not take a 'cache' attribute";
    protected String cacheNotValidForBindingType$str() {
        return cacheNotValidForBindingType;
    }
    @Override
    public final OperationFailedException cacheNotValidForBindingType(final BindingType type) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cacheNotValidForBindingType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String lookupError = "WFLYNAM0062: Failed to lookup %s";
    protected String lookupError$str() {
        return lookupError;
    }
    @Override
    public final NamingException lookupError(final Throwable cause, final String name) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), lookupError$str(), name));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceNotStarted = "WFLYNAM0063: %s service not started";
    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }
    @Override
    public final IllegalStateException serviceNotStarted(final ServiceName serviceName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceNotStarted$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRebindExternalContext = "WFLYNAM0064: Cannot rebind external context lookup";
    protected String cannotRebindExternalContext$str() {
        return cannotRebindExternalContext;
    }
    @Override
    public final OperationFailedException cannotRebindExternalContext() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotRebindExternalContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moduleNotFound = "WFLYNAM0065: Could not load module %s - the module or one of its dependencies is missing [%s]";
    protected String moduleNotFound$str() {
        return moduleNotFound;
    }
    @Override
    public final OperationFailedException moduleNotFound(final ModuleIdentifier moduleID, final String missingModule) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), moduleNotFound$str(), moduleID, missingModule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
