/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

public class OpenTelemetryConfig {
    public final String serviceName;
    public final String exporter;
    public final String endpoint;
    public final String spanProcessor;
    public final long batchDelay;
    public final int maxQueueSize;
    public final int maxExportBatchSize;
    public final long exportTimeout;
    public final String sampler;
    public final Double ratio;

    private OpenTelemetryConfig(String serviceName, String exporter, String endpoint, String spanProcessor, long batchDelay, int maxQueueSize, int maxExportBatchSize, long exportTimeout, String sampler, Double ratio) {
        this.serviceName = serviceName;
        this.exporter = exporter;
        this.endpoint = endpoint;
        this.spanProcessor = spanProcessor;
        this.batchDelay = batchDelay;
        this.maxQueueSize = maxQueueSize;
        this.maxExportBatchSize = maxExportBatchSize;
        this.exportTimeout = exportTimeout;
        this.sampler = sampler;
        this.ratio = ratio;
    }

    public static class OpenTelemetryConfigBuilder {
        private String serviceName;
        private String exporter;
        private String endpoint;
        private String spanProcessor;
        private long batchDelay;
        private int maxQueueSize;
        private int maxExportBatchSize;
        private long exportTimeout;
        private String sampler;
        private Double ratio;

        private OpenTelemetryConfigBuilder() {
        }

        public static OpenTelemetryConfigBuilder config() {
            return new OpenTelemetryConfigBuilder();
        }

        public OpenTelemetryConfigBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public OpenTelemetryConfigBuilder withExporter(String exporter) {
            this.exporter = exporter;
            return this;
        }

        public OpenTelemetryConfigBuilder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public OpenTelemetryConfigBuilder withSpanProcessor(String spanProcessor) {
            this.spanProcessor = spanProcessor;
            return this;
        }

        public OpenTelemetryConfigBuilder withBatchDelay(long batchDelay) {
            this.batchDelay = batchDelay;
            return this;
        }

        public OpenTelemetryConfigBuilder withMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public OpenTelemetryConfigBuilder withMaxExportBatchSize(int maxExportBatchSize) {
            this.maxExportBatchSize = maxExportBatchSize;
            return this;
        }

        public OpenTelemetryConfigBuilder withExportTimeout(long exportTimeout) {
            this.exportTimeout = exportTimeout;
            return this;
        }

        public OpenTelemetryConfigBuilder withSampler(String sampler) {
            this.sampler = sampler;
            return this;
        }

        public OpenTelemetryConfigBuilder withRatio(Double ratio) {
            this.ratio = ratio;
            return this;
        }

        public OpenTelemetryConfig build() {
            return new OpenTelemetryConfig(this.serviceName, this.exporter, this.endpoint, this.spanProcessor, this.batchDelay, this.maxQueueSize, this.maxExportBatchSize, this.exportTimeout, this.sampler, this.ratio);
        }
    }
}

