/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.configadmin;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.felix.cm.PersistenceManager;
import org.jboss.as.configadmin.ConfigAdmin;
import org.jboss.as.configadmin.ConfigAdminListener;
import org.jboss.as.configadmin.ConfigAdminLogger;
import org.jboss.as.osgi.configadmin.DomainModelListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DomainModelPersistenceManager
implements PersistenceManager,
BundleActivator {
    private ConfigAdmin configAdminService;
    private DomainModelListener configAdminListener;

    public void start(BundleContext context) throws Exception {
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", Integer.MAX_VALUE);
        context.registerService(PersistenceManager.class.getName(), (Object)this, props);
        this.configAdminListener = new DomainModelListener(context);
        this.configAdminService = this.getConfigAdminService(context);
        this.configAdminService.addListener((ConfigAdminListener)this.configAdminListener);
    }

    public void stop(BundleContext context) throws Exception {
        this.configAdminListener.stop();
        this.configAdminService.removeListener((ConfigAdminListener)this.configAdminListener);
    }

    public boolean exists(String pid) {
        return this.configAdminService.hasConfiguration(pid);
    }

    public Dictionary<String, String> load(String pid) throws IOException {
        Dictionary props = this.configAdminService.getConfiguration(pid);
        Dictionary<String, String> result = this.addStandardProperties(pid, props);
        ConfigAdminLogger.LOGGER.debugf("PM load %s => %s", (Object)pid, result);
        return result;
    }

    public Enumeration<Dictionary<String, String>> getDictionaries() throws IOException {
        Vector<Dictionary<String, String>> result = new Vector<Dictionary<String, String>>();
        for (String pid : this.configAdminService.getConfigurations()) {
            Dictionary props = this.configAdminService.getConfiguration(pid);
            result.add(this.addStandardProperties(pid, props));
        }
        return result.elements();
    }

    public void store(String pid, Dictionary source) throws IOException {
        Dictionary<String, String> dictionary = this.removeUnsupportedProperties(source);
        dictionary.put(".transient.skip.cm.update", "true");
        ConfigAdminLogger.LOGGER.debugf("PM store %s => %s", (Object)pid, dictionary);
        this.configAdminService.putConfiguration(pid, dictionary);
    }

    public void delete(String pid) throws IOException {
        ConfigAdminLogger.LOGGER.debugf("PM delete %s", (Object)pid);
        this.configAdminService.removeConfiguration(pid);
    }

    private ConfigAdmin getConfigAdminService(BundleContext context) {
        ServiceReference sref = context.getServiceReference(ServiceContainer.class.getName());
        ServiceContainer serviceContainer = (ServiceContainer)context.getService(sref);
        ServiceController controller = serviceContainer.getRequiredService(ConfigAdmin.SERVICE_NAME);
        return (ConfigAdmin)controller.getValue();
    }

    private Dictionary<String, String> addStandardProperties(String pid, Dictionary<String, String> source) {
        Dictionary<String, String> copy = this.getModifiableDictionary(source);
        copy.put("service.pid", pid);
        return copy;
    }

    private Dictionary<String, String> removeUnsupportedProperties(Dictionary<String, Object> source) {
        Hashtable<String, String> copy = new Hashtable<String, String>();
        Enumeration<String> keys = source.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = source.get(key);
            if (!(value instanceof String)) continue;
            ((Dictionary)copy).put(key, (String)value);
        }
        return copy;
    }

    private Dictionary<String, String> removeStandardProperties(Dictionary<String, String> source) {
        Dictionary<String, String> copy = this.getModifiableDictionary(source);
        copy.remove("service.bundleLocation");
        copy.remove("service.pid");
        return copy;
    }

    private Dictionary<String, String> getModifiableDictionary(Dictionary<String, String> source) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (source != null) {
            Enumeration<String> keys = source.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                ((Dictionary)result).put(key, source.get(key));
            }
        }
        return result;
    }
}

