/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.jpa;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.spi.PersistenceUnitService;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class PersistenceUnitProcessor
implements DeploymentUnitProcessor {
    private static AttachmentKey<BundleListener> BUNDLE_LISTENER_KEY = AttachmentKey.create(BundleListener.class);

    public void deploy(final DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        final DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        final ServiceName puServiceName = (ServiceName)depUnit.getAttachment(JpaAttachments.PERSISTENCE_UNIT_SERVICE_KEY);
        final XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        if (brev == null || puServiceName == null) {
            return;
        }
        BundleContext syscontext = (BundleContext)depUnit.getAttachment(OSGiConstants.SYSTEM_CONTEXT_KEY);
        SynchronousBundleListener listener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == brev.getBundle() && event.getType() == 2) {
                    BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
                    EntityManagerFactoryRegistration.addService(phaseContext.getServiceTarget(), bundleManager, puServiceName, brev);
                }
            }
        };
        syscontext.addBundleListener((BundleListener)listener);
        depUnit.putAttachment(BUNDLE_LISTENER_KEY, (Object)listener);
    }

    public void undeploy(DeploymentUnit depUnit) {
        BundleListener listener = (BundleListener)depUnit.getAttachment(BUNDLE_LISTENER_KEY);
        if (listener != null) {
            BundleContext syscontext = (BundleContext)depUnit.getAttachment(OSGiConstants.SYSTEM_CONTEXT_KEY);
            syscontext.removeBundleListener(listener);
        }
    }

    static class EntityManagerFactoryRegistration
    implements Service<ServiceRegistration<EntityManagerFactory>> {
        private final InjectedValue<PersistenceUnitService> injectedPersistenceUnitService = new InjectedValue();
        private final XBundle bundle;
        private ServiceRegistration<EntityManagerFactory> registration;

        static void addService(ServiceTarget serviceTarget, BundleManager bundleManager, ServiceName puServiceName, XBundleRevision brev) {
            ServiceName serviceName = puServiceName.append(new String[]{EntityManagerFactory.class.getSimpleName()});
            EntityManagerFactoryRegistration service = new EntityManagerFactoryRegistration(brev.getBundle());
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
            builder.addDependency(puServiceName, PersistenceUnitService.class, service.injectedPersistenceUnitService);
            builder.setInitialMode(ServiceController.Mode.PASSIVE);
            builder.install();
        }

        private EntityManagerFactoryRegistration(XBundle bundle) {
            this.bundle = bundle;
        }

        public void start(StartContext context) throws StartException {
            BundleContext bundleContext = this.bundle.getBundleContext();
            PersistenceUnitService puService = (PersistenceUnitService)this.injectedPersistenceUnitService.getValue();
            EntityManagerFactory emf = puService.getEntityManagerFactory();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.unit.name", puService.getScopedPersistenceUnitName());
            ((Dictionary)properties).put("osgi.unit.version", "unknown");
            ((Dictionary)properties).put("osgi.unit.provider", "unknown");
            this.registration = bundleContext.registerService(EntityManagerFactory.class, (Object)emf, properties);
        }

        public void stop(StopContext context) {
            if (this.registration != null) {
                this.registration.unregister();
                this.registration = null;
            }
        }

        public ServiceRegistration<EntityManagerFactory> getValue() throws IllegalStateException, IllegalArgumentException {
            return this.registration;
        }
    }
}

