/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.FutureServiceValue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

final class FrameworkProxy
implements Framework {
    private final StandaloneServer server;
    private int state = 2;
    private BundleContext bundleContext;

    FrameworkProxy(StandaloneServer server) {
        this.server = server;
    }

    public long getBundleId() {
        return 0L;
    }

    public String getSymbolicName() {
        return "system.bundle";
    }

    public String getLocation() {
        return "System Bundle";
    }

    public Version getVersion() {
        return Version.emptyVersion;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public int getState() {
        return this.bundleContext != null ? this.bundleContext.getBundle().getState() : this.state;
    }

    public void init() throws BundleException {
        int state = this.getState();
        if (state == 8 || state == 32 || state == 16) {
            return;
        }
        try {
            this.server.start();
        }
        catch (Throwable th) {
            throw new BundleException("Cannot start the server", th);
        }
        try {
            ModelControllerClient client = this.server.getModelControllerClient();
            ModelNode op = FrameworkProxy.createOpNode("subsystem=osgi", "activate");
            FrameworkProxy.executeOperation(client, op, true);
        }
        catch (Throwable th) {
            throw new BundleException("Cannot activate the osgi subsystem", th);
        }
        try {
            ServiceController controller = this.server.getService(Services.FRAMEWORK_INIT);
            FutureServiceValue future = new FutureServiceValue(controller);
            this.bundleContext = (BundleContext)future.get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable th) {
            throw new BundleException("Cannot get bundle context", th);
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        int state = this.getState();
        if (state != 8) {
            this.init();
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        try {
            this.server.stop();
        }
        catch (Throwable th) {
            throw new BundleException("Cannot stop the server", th);
        }
        finally {
            this.bundleContext = null;
            this.state = 4;
        }
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        return new FrameworkEvent(64, (Bundle)this, null);
    }

    public void update(InputStream input) throws BundleException {
        throw new UnsupportedOperationException();
    }

    public void update() {
        throw new UnsupportedOperationException();
    }

    public void uninstall() throws BundleException {
        throw new UnsupportedOperationException();
    }

    public Dictionary<String, String> getHeaders() {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getHeaders();
    }

    public ServiceReference<?>[] getRegisteredServices() {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getRegisteredServices();
    }

    public ServiceReference<?>[] getServicesInUse() {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getServicesInUse();
    }

    public boolean hasPermission(Object permission) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().hasPermission(permission);
    }

    public URL getResource(String name) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getResource(name);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getHeaders(locale);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getEntry(path);
    }

    public long getLastModified() {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().findEntries(path, filePattern, recurse);
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getSignerCertificates(signersType);
    }

    public int compareTo(Bundle other) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().compareTo((Object)other);
    }

    public <A> A adapt(Class<A> type) {
        this.assertValidBundleContext();
        return (A)this.bundleContext.getBundle().adapt(type);
    }

    public File getDataFile(String filename) {
        this.assertValidBundleContext();
        return this.bundleContext.getBundle().getDataFile(filename);
    }

    private void assertValidBundleContext() {
        if (this.bundleContext == null) {
            throw new IllegalStateException("Framework bundle context not available");
        }
    }

    private static ModelNode createOpNode(String address, String operation) {
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        op.get("operation").set(operation);
        return op;
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op, boolean unwrapResult) throws Exception {
        ModelNode ret = client.execute(op);
        if (!unwrapResult) {
            return ret;
        }
        if (!"success".equals(ret.get("outcome").asString())) {
            throw new IllegalStateException("Management operation failed: " + ret.get("failure-description"));
        }
        return ret.get("result");
    }
}

