/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.launcher;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.wildfly.security.manager.WildFlySecurityManager;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static void setAccessible(final Method method) throws SecurityException {
        if (method == null) {
            throw new IllegalArgumentException("method must be specified");
        }
        if (!WildFlySecurityManager.isChecking()) {
            method.setAccessible(true);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        method.setAccessible(true);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof SecurityException) {
                    throw (SecurityException)cause;
                }
                throw new RuntimeException("Unexpected exception encountered setting accessibility of " + method + " to true", cause);
            }
        }
    }
}

