/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.mechanism;

import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTParser;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.Set;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@ApplicationScoped
public class JWTHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static Logger logger = Logger.getLogger(JWTHttpAuthenticationMechanism.class);
    @Inject
    private JWTAuthContextInfo authContextInfo;
    @Inject
    private JWTParser jwtParser;
    @Inject
    private PrincipalProducer producer;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        BearerTokenExtractor extractor = new BearerTokenExtractor(request, this.authContextInfo);
        String bearerToken = extractor.getBearerToken();
        if (bearerToken != null) {
            try {
                JsonWebToken jwtPrincipal = this.jwtParser.parse(bearerToken);
                this.producer.setJsonWebToken(jwtPrincipal);
                Set groups = jwtPrincipal.getGroups();
                logger.debugf("Success", new Object[0]);
                return httpMessageContext.notifyContainerAboutLogin((Principal)jwtPrincipal, groups);
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to validate bearer token", (Throwable)e);
                return httpMessageContext.responseUnauthorized();
            }
        }
        logger.debug((Object)"No usable bearer token was found in the request, continuing unauthenticated");
        return httpMessageContext.isProtected() ? httpMessageContext.responseUnauthorized() : httpMessageContext.doNothing();
    }

    private static class BearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private final HttpServletRequest request;

        BearerTokenExtractor(HttpServletRequest request, JWTAuthContextInfo authContextInfo) {
            super(authContextInfo);
            this.request = request;
        }

        @Override
        protected String getHeaderValue(String headerName) {
            return this.request.getHeader(headerName);
        }

        @Override
        protected String getCookieValue(String cookieName) {
            Cookie[] cookies = this.request.getCookies();
            Cookie tokenCookie = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    tokenCookie = cookie;
                    break;
                }
            }
            if (tokenCookie != null) {
                return tokenCookie.getValue();
            }
            return null;
        }
    }
}

