/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.serialization;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.contrib.jaxrs2.serialization.InterceptorSpanDecorator;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.tag.Tags;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.InterceptorContext;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class TracingInterceptor
implements WriterInterceptor,
ReaderInterceptor {
    private final Tracer tracer;
    private final Collection<InterceptorSpanDecorator> spanDecorators;

    public TracingInterceptor(Tracer tracer, List<InterceptorSpanDecorator> spanDecorators) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(spanDecorators);
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<InterceptorSpanDecorator>(spanDecorators);
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        Throwable throwable = null;
        try (Scope scope = this.decorateRead((InterceptorContext)context, this.buildSpan((InterceptorContext)context, "deserialize"));){
            Object object = context.proceed();
            return object;
        }
        catch (Exception e) {
            try {
                Tags.ERROR.set(scope.span(), Boolean.valueOf(true));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try (Scope scope = this.decorateWrite((InterceptorContext)context, this.buildSpan((InterceptorContext)context, "serialize"));){
            try {
                context.proceed();
            }
            catch (Exception e) {
                Tags.ERROR.set(scope.span(), Boolean.valueOf(true));
                throw e;
            }
        }
    }

    private Scope buildSpan(InterceptorContext context, String operationName) {
        SpanWrapper spanWrapper = this.findSpan(context);
        if (spanWrapper == null) {
            return NoopScopeManager.NoopScope.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName);
        if (spanWrapper.isFinished()) {
            spanBuilder.addReference("follows_from", spanWrapper.get().context());
        } else {
            spanBuilder.asChildOf(spanWrapper.get());
        }
        return spanBuilder.startActive(true);
    }

    protected abstract SpanWrapper findSpan(InterceptorContext var1);

    private Scope decorateRead(InterceptorContext context, Scope span) {
        for (InterceptorSpanDecorator decorator : this.spanDecorators) {
            decorator.decorateRead(context, span.span());
        }
        return span;
    }

    private Scope decorateWrite(InterceptorContext context, Scope span) {
        for (InterceptorSpanDecorator decorator : this.spanDecorators) {
            decorator.decorateWrite(context, span.span());
        }
        return span;
    }
}

