/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.concurrent.Future;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInterceptorInformation;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.annotation.ClientAsynchronous;
import org.jboss.ejb.client.annotation.ClientInterceptors;
import org.jboss.ejb.client.annotation.ClientTransaction;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.jboss.ejb.client.annotation.CompressionHint;
import org.jboss.ejb.client.annotation.Idempotent;

final class EJBProxyInformation<T> {
    static final boolean ENABLE_SCANNING = AccessController.doPrivileged(() -> Boolean.valueOf(System.getProperty("org.jboss.ejb.client.view.annotation.scan.enabled", "true")));
    static final Class<?>[] JUST_INV_HANDLER = new Class[]{InvocationHandler.class};
    static final int MT_BUSINESS = 0;
    static final int MT_EQUALS = 1;
    static final int MT_HASH_CODE = 2;
    static final int MT_TO_STRING = 3;
    static final int MT_GET_PRIMARY_KEY = 4;
    static final int MT_GET_HANDLE = 5;
    static final int MT_IS_IDENTICAL = 6;
    static final int MT_GET_HOME_HANDLE = 7;
    private static final ClassValue<EJBProxyInformation<?>> PROXY_INFORMATION_CLASS_VALUE = new ClassValue<EJBProxyInformation<?>>(){

        @Override
        protected EJBProxyInformation<?> computeValue(Class<?> type) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(() -> this.doCompute(type));
            }
            return this.doCompute(type);
        }

        private <P> EJBProxyInformation<P> doCompute(Class<P> type) {
            Constructor<P> constructor;
            Field[] declaredFields;
            ProxyMethodInfo.CompressionHint classCompressRequest;
            ProxyMethodInfo.CompressionHint classCompressResponse;
            int classCompressionLevel;
            Class<P> proxyClass = Proxy.getProxyClass(type.getClassLoader(), type).asSubclass(type);
            HashMap<Method, ProxyMethodInfo> fallbackMap = new HashMap<Method, ProxyMethodInfo>();
            IdentityHashMap<Method, ProxyMethodInfo> methodInfoMap = new IdentityHashMap<Method, ProxyMethodInfo>();
            HashMap<EJBMethodLocator, ProxyMethodInfo> methodLocatorMap = new HashMap<EJBMethodLocator, ProxyMethodInfo>();
            CompressionHint classCompressionHint = ENABLE_SCANNING ? type.getAnnotation(CompressionHint.class) : null;
            ClientTransaction classTransactionHint = ENABLE_SCANNING ? type.getAnnotation(ClientTransaction.class) : null;
            ClientInterceptors classClientInterceptors = ENABLE_SCANNING ? type.getAnnotation(ClientInterceptors.class) : null;
            EJBClientContext.InterceptorList classInterceptors = this.getInterceptorsFromAnnotation(classClientInterceptors);
            if (classCompressionHint == null) {
                classCompressionLevel = -1;
                classCompressRequest = classCompressResponse = ProxyMethodInfo.CompressionHint.NONE;
            } else {
                classCompressionLevel = classCompressionHint.compressionLevel() == -1 ? -1 : classCompressionHint.compressionLevel();
                classCompressRequest = ProxyMethodInfo.CompressionHint.fromBoolean(classCompressionHint.compressRequest());
                classCompressResponse = ProxyMethodInfo.CompressionHint.fromBoolean(classCompressionHint.compressResponse());
            }
            boolean classIdempotent = ENABLE_SCANNING && type.getAnnotation(Idempotent.class) != null;
            boolean classAsync = ENABLE_SCANNING && type.getAnnotation(ClientAsynchronous.class) != null;
            for (Field declaredField : declaredFields = proxyClass.getDeclaredFields()) {
                declaredField.setAccessible(true);
                if (declaredField.getType() != Method.class || declaredField.getName().charAt(0) != 'm' || (declaredField.getModifiers() & 8) == 0) continue;
                try {
                    ProxyMethodInfo.CompressionHint compressResponse;
                    ProxyMethodInfo.CompressionHint compressRequest;
                    int compressionLevel;
                    Method method = (Method)declaredField.get(null);
                    boolean alwaysAsync = method.getReturnType() == Future.class;
                    boolean idempotent = classIdempotent || ENABLE_SCANNING && method.getAnnotation(Idempotent.class) != null;
                    boolean clientAsync = alwaysAsync || classAsync || ENABLE_SCANNING && method.getAnnotation(ClientAsynchronous.class) != null;
                    CompressionHint compressionHint = ENABLE_SCANNING ? method.getAnnotation(CompressionHint.class) : null;
                    ClientTransaction transactionHint = ENABLE_SCANNING ? method.getAnnotation(ClientTransaction.class) : null;
                    ClientInterceptors clientInterceptors = ENABLE_SCANNING ? method.getAnnotation(ClientInterceptors.class) : null;
                    EJBClientContext.InterceptorList interceptors = this.getInterceptorsFromAnnotation(clientInterceptors);
                    if (compressionHint == null) {
                        compressionLevel = classCompressionLevel;
                        compressRequest = classCompressRequest;
                        compressResponse = classCompressResponse;
                    } else {
                        compressionLevel = compressionHint.compressionLevel() == -1 ? -1 : compressionHint.compressionLevel();
                        compressRequest = ProxyMethodInfo.CompressionHint.fromBoolean(compressionHint.compressRequest());
                        compressResponse = ProxyMethodInfo.CompressionHint.fromBoolean(compressionHint.compressResponse());
                    }
                    ClientTransactionPolicy transactionPolicy = transactionHint != null ? transactionHint.value() : (clientAsync ? ClientTransactionPolicy.NOT_SUPPORTED : (classTransactionHint != null ? classTransactionHint.value() : ClientTransactionPolicy.SUPPORTS));
                    StringBuilder b = new StringBuilder();
                    Class<?>[] methodParamTypes = method.getParameterTypes();
                    String[] parameterTypeNames = new String[methodParamTypes.length];
                    if (parameterTypeNames.length > 0) {
                        parameterTypeNames[0] = methodParamTypes[0].getName();
                        b.append(parameterTypeNames[0]);
                        for (int i = 1; i < methodParamTypes.length; ++i) {
                            b.append(',');
                            parameterTypeNames[i] = methodParamTypes[i].getName();
                            b.append(parameterTypeNames[i]);
                        }
                    }
                    String methodName = method.getName();
                    int methodType = this.getMethodType(type, methodName, methodParamTypes);
                    EJBMethodLocator methodLocator = new EJBMethodLocator(methodName, parameterTypeNames);
                    ProxyMethodInfo proxyMethodInfo = new ProxyMethodInfo(methodType, compressionLevel, compressRequest, compressResponse, idempotent, transactionPolicy, method, methodLocator, b.toString(), clientAsync, interceptors);
                    methodInfoMap.put(method, proxyMethodInfo);
                    fallbackMap.put(method, proxyMethodInfo);
                    methodLocatorMap.put(methodLocator, proxyMethodInfo);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
            }
            try {
                constructor = proxyClass.getConstructor(JUST_INV_HANDLER);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError("No valid constructor found on proxy class");
            }
            return new EJBProxyInformation<P>(proxyClass, constructor, methodInfoMap, fallbackMap, methodLocatorMap, classCompressionLevel, classIdempotent, classAsync, classInterceptors);
        }

        private EJBClientContext.InterceptorList getInterceptorsFromAnnotation(ClientInterceptors classClientInterceptors) {
            if (classClientInterceptors != null) {
                Class<? extends EJBClientInterceptor>[] interceptorClasses = classClientInterceptors.value();
                int length = interceptorClasses.length;
                if (length == 0) {
                    return EJBClientContext.InterceptorList.EMPTY;
                }
                if (length == 1) {
                    return EJBClientInterceptorInformation.forClass(interceptorClasses[0]).getSingletonList();
                }
                EJBClientInterceptorInformation[] interceptors = new EJBClientInterceptorInformation[length];
                for (int i = 0; i < length; ++i) {
                    interceptors[i] = EJBClientInterceptorInformation.forClass(interceptorClasses[i]);
                }
                return new EJBClientContext.InterceptorList(interceptors);
            }
            return EJBClientContext.InterceptorList.EMPTY;
        }

        private int getMethodType(Class<?> interfaceClass, String name, Class<?>[] methodParamTypes) {
            switch (name) {
                case "equals": {
                    if (methodParamTypes.length != 1 || methodParamTypes[0] != Object.class) break;
                    return 1;
                }
                case "hashCode": {
                    if (methodParamTypes.length != 0) break;
                    return 2;
                }
                case "toString": {
                    if (methodParamTypes.length != 0) break;
                    return 3;
                }
                case "getPrimaryKey": {
                    if (methodParamTypes.length != 0 || !EJBObject.class.isAssignableFrom(interfaceClass)) break;
                    return 4;
                }
                case "getHandle": {
                    if (methodParamTypes.length != 0 || !EJBObject.class.isAssignableFrom(interfaceClass)) break;
                    return 5;
                }
                case "isIdentical": {
                    if (methodParamTypes.length != 1 || !EJBObject.class.isAssignableFrom(interfaceClass) || methodParamTypes[0] != EJBObject.class) break;
                    return 6;
                }
                case "getHomeHandle": {
                    if (methodParamTypes.length != 0 || !EJBHome.class.isAssignableFrom(interfaceClass)) break;
                    return 7;
                }
            }
            return 0;
        }
    };
    private final Class<? extends T> proxyClass;
    private final Constructor<? extends T> proxyConstructor;
    private final IdentityHashMap<Method, ProxyMethodInfo> methodInfoMap;
    private final HashMap<Method, ProxyMethodInfo> fallbackMap;
    private final HashMap<EJBMethodLocator, ProxyMethodInfo> methodLocatorMap;
    private final int classCompressionHint;
    private final boolean classIdempotent;
    private final boolean classAsync;
    private final EJBClientContext.InterceptorList classInterceptors;

    EJBProxyInformation(Class<? extends T> proxyClass, Constructor<? extends T> proxyConstructor, IdentityHashMap<Method, ProxyMethodInfo> methodInfoMap, HashMap<Method, ProxyMethodInfo> fallbackMap, HashMap<EJBMethodLocator, ProxyMethodInfo> methodLocatorMap, int classCompressionHint, boolean classIdempotent, boolean classAsync, EJBClientContext.InterceptorList classInterceptors) {
        this.proxyClass = proxyClass;
        this.proxyConstructor = proxyConstructor;
        this.methodInfoMap = methodInfoMap;
        this.fallbackMap = fallbackMap;
        this.methodLocatorMap = methodLocatorMap;
        this.classCompressionHint = classCompressionHint;
        this.classIdempotent = classIdempotent;
        this.classAsync = classAsync;
        this.classInterceptors = classInterceptors;
    }

    static <T> EJBProxyInformation<T> forViewType(Class<T> clazz) {
        return PROXY_INFORMATION_CLASS_VALUE.get(clazz);
    }

    boolean hasCompressionHint(Method proxyMethod) {
        ProxyMethodInfo proxyMethodInfo = this.getProxyMethodInfo(proxyMethod);
        return proxyMethodInfo != null && proxyMethodInfo.compressionLevel != -1;
    }

    boolean isIdempotent(Method proxyMethod) {
        ProxyMethodInfo proxyMethodInfo = this.getProxyMethodInfo(proxyMethod);
        return proxyMethodInfo != null && (this.classIdempotent || proxyMethodInfo.idempotent);
    }

    Class<? extends T> getProxyClass() {
        return this.proxyClass;
    }

    Constructor<? extends T> getProxyConstructor() {
        return this.proxyConstructor;
    }

    int getClassCompressionHint() {
        return this.classCompressionHint;
    }

    boolean isClassIdempotent() {
        return this.classIdempotent;
    }

    boolean isClassAsync() {
        return this.classAsync;
    }

    ProxyMethodInfo getProxyMethodInfo(Method method) {
        ProxyMethodInfo info = this.methodInfoMap.get(method);
        return info == null ? this.fallbackMap.get(method) : info;
    }

    ProxyMethodInfo getProxyMethodInfo(EJBMethodLocator locator) {
        return this.methodLocatorMap.get(locator);
    }

    EJBClientContext.InterceptorList getClassInterceptors() {
        return this.classInterceptors;
    }

    Collection<ProxyMethodInfo> getMethods() {
        return this.methodInfoMap.values();
    }

    static final class ProxyMethodInfo {
        final int methodType;
        final int compressionLevel;
        final CompressionHint compressRequest;
        final CompressionHint compressResponse;
        final boolean idempotent;
        final ClientTransactionPolicy transactionPolicy;
        final Method method;
        final EJBMethodLocator methodLocator;
        final String signature;
        final boolean clientAsync;
        final EJBClientContext.InterceptorList interceptors;

        ProxyMethodInfo(int methodType, int compressionLevel, CompressionHint compressRequest, CompressionHint compressResponse, boolean idempotent, ClientTransactionPolicy transactionPolicy, Method method, EJBMethodLocator methodLocator, String signature, boolean clientAsync, EJBClientContext.InterceptorList interceptors) {
            this.methodType = methodType;
            this.compressionLevel = compressionLevel;
            this.compressRequest = compressRequest;
            this.compressResponse = compressResponse;
            this.idempotent = idempotent;
            this.transactionPolicy = transactionPolicy;
            this.method = method;
            this.methodLocator = methodLocator;
            this.signature = signature;
            this.clientAsync = clientAsync;
            this.interceptors = interceptors;
        }

        public int getMethodType() {
            return this.methodType;
        }

        int getCompressionLevel() {
            return this.compressionLevel;
        }

        boolean isIdempotent() {
            return this.idempotent;
        }

        ClientTransactionPolicy getTransactionPolicy() {
            return this.transactionPolicy;
        }

        Method getMethod() {
            return this.method;
        }

        String getSignature() {
            return this.signature;
        }

        boolean isClientAsync() {
            return this.clientAsync;
        }

        CompressionHint getCompressRequestHint() {
            return this.compressRequest;
        }

        CompressionHint getCompressResponseHint() {
            return this.compressResponse;
        }

        EJBMethodLocator getMethodLocator() {
            return this.methodLocator;
        }

        EJBClientContext.InterceptorList getInterceptors() {
            return this.interceptors;
        }

        boolean isSynchronous() {
            Class<?> returnType = this.method.getReturnType();
            return returnType != Void.TYPE && returnType != Future.class;
        }

        static enum CompressionHint {
            NONE,
            TRUE,
            FALSE;


            static CompressionHint fromBoolean(boolean hint) {
                return hint ? TRUE : FALSE;
            }
        }
    }
}

