/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;

class StaticHeadersHandler
implements HttpHandler {
    private final Map<String, List<HeaderConstant>> headersMap = new TreeMap<String, List<HeaderConstant>>(String.CASE_INSENSITIVE_ORDER);
    private final HttpHandler next;

    StaticHeadersHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        final String requestPath = exchange.getRelativePath();
        exchange.addResponseCommitListener(new ResponseCommitListener(){

            public void beforeCommit(HttpServerExchange exchange) {
                Predicate<String> putHeadersTest = new Predicate<String>(){
                    Set<String> putHeaders = new HashSet<String>();

                    @Override
                    public boolean test(String t) {
                        if (this.putHeaders.contains(t)) {
                            return false;
                        }
                        this.putHeaders.add(t);
                        return true;
                    }
                };
                for (Map.Entry entry : StaticHeadersHandler.this.headersMap.entrySet()) {
                    if (!requestPath.startsWith((String)entry.getKey())) continue;
                    for (HeaderConstant constant : (List)entry.getValue()) {
                        constant.apply(exchange, putHeadersTest);
                    }
                }
            }
        });
        this.next.handleRequest(exchange);
    }

    void addHeader(String path, String header, String value) {
        String actualPath = path.startsWith("/") ? path : "/" + path;
        List headers = this.headersMap.computeIfAbsent(actualPath, s -> new ArrayList());
        headers.add(new HeaderConstant(header, value));
    }

    private static class HeaderConstant {
        private final HttpString headerName;
        private final String value;

        HeaderConstant(String headerName, String value) {
            this.headerName = new HttpString(headerName);
            this.value = value;
        }

        void apply(HttpServerExchange exchange, Predicate<String> putHeader) {
            HeaderMap headers = exchange.getResponseHeaders();
            if (putHeader.test(this.headerName.toString())) {
                headers.put(this.headerName, this.value);
            } else {
                headers.add(this.headerName, this.value);
            }
        }
    }
}

